/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Spore;
import com.Harbinger.Spore.core.SConfig;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.world.ModifiableStructureInfo;
import net.neoforged.neoforge.common.world.StructureModifier;

public class StructureModification
implements StructureModifier {
    public static final MapCodec<StructureModification> CODEC = MapCodec.unit(StructureModification::new);

    public static MapCodec<StructureModification> makeCodec() {
        return CODEC;
    }

    public MapCodec<? extends StructureModifier> codec() {
        return CODEC;
    }

    public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
        if (phase != StructureModifier.Phase.ADD) {
            return;
        }
        TagKey labTag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"laboratories"));
        if (!structure.is(labTag)) {
            return;
        }
        if (((List)SConfig.SERVER.structure_spawns.get()).isEmpty()) {
            return;
        }
        for (String entry : (List)SConfig.SERVER.structure_spawns.get()) {
            String[] parts = entry.split("\\|");
            if (parts.length != 4) {
                Spore.LOGGER.warn("Invalid structure spawn config entry: {}", (Object)entry);
                continue;
            }
            ResourceLocation entityId = ResourceLocation.parse((String)parts[0]);
            EntityType<?> entity = Utilities.tryToCreateEntity(entityId);
            if (entity == null) {
                Spore.LOGGER.warn("Unknown entity type: {}", (Object)parts[0]);
                continue;
            }
            try {
                int weight = Integer.parseInt(parts[1]);
                int min = Integer.parseInt(parts[2]);
                int max = Integer.parseInt(parts[3]);
                builder.getStructureSettings().getOrAddSpawnOverrides(entity.getCategory()).addSpawn(new MobSpawnSettings.SpawnerData(entity, weight, min, max));
            }
            catch (NumberFormatException e) {
                Spore.LOGGER.error("Invalid number in structure spawn config: {}", (Object)entry, (Object)e);
            }
        }
    }
}

