/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings;

import com.Harbinger.Spore.ExtremelySusThings.BooleanCache;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.core.SAttributes;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class Utilities {
    public static final List<BlockState> biomass = Utilities.createBiomass();
    public static final Predicate<LivingEntity> TARGET_SELECTOR_PREDICATE = entity -> {
        if (entity instanceof UtilityEntity || entity instanceof TrueCalamity) {
            return false;
        }
        if ((entity instanceof AbstractFish || entity instanceof Animal) && !((Boolean)SConfig.SERVER.at_an.get()).booleanValue()) {
            return false;
        }
        if (!((List)SConfig.SERVER.blacklist.get()).isEmpty()) {
            for (String string : (List)SConfig.SERVER.blacklist.get()) {
                String[] iterations;
                String[] mod;
                if (!string.endsWith(":") || entity.getEncodeId() == null || !Objects.equals((mod = string.split(":"))[0], (iterations = entity.getEncodeId().split(":"))[0])) continue;
                return false;
            }
            return !((List)SConfig.SERVER.blacklist.get()).contains(entity.getEncodeId());
        }
        return true;
    };
    public static BooleanCache<LivingEntity> TARGET_SELECTOR = new BooleanCache<LivingEntity>(8, TARGET_SELECTOR_PREDICATE);

    public static void explodeCircle(ServerLevel level, Entity owner, BlockPos pos, double range, float damage, double blockHardness, Predicate<Entity> predicate) {
        Utilities.explodeCircle(level, owner, pos, range, damage, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, false, blockHardness, predicate);
    }

    public static void explodeCircle(ServerLevel level, Entity owner, BlockPos pos, double range, float damage, ParticleOptions particleTypes, boolean dropItems, double blockHardness, Predicate<Entity> predicate) {
        RandomSource random = RandomSource.create();
        int i = 0;
        while ((double)i <= 2.0 * range) {
            int j = 0;
            while ((double)j <= 2.0 * range) {
                int k = 0;
                while ((double)k <= 2.0 * range) {
                    BlockPos blockpos;
                    BlockState state;
                    float hardness;
                    double distance = Mth.sqrt((float)((float)(((double)i - range) * ((double)i - range) + ((double)j - range) * ((double)j - range) + ((double)k - range) * ((double)k - range))));
                    if (distance < range + 0.5 && (hardness = (state = level.getBlockState(blockpos = pos.offset(i - (int)range, j - (int)range, k - (int)range))).getDestroySpeed((BlockGetter)level, blockpos)) >= 0.0f && (double)hardness <= blockHardness && EventHooks.canEntityGrief((Level)level, (Entity)owner)) {
                        level.removeBlock(blockpos, dropItems);
                        if (random.nextFloat() < 0.3f) {
                            float offset = random.nextFloat() * 0.05f;
                            level.sendParticles(particleTypes, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5, 1, (double)offset, 0.0, (double)offset, 1.0);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        AABB searchBox = AABB.ofSize((Vec3)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (double)(range * 2.0), (double)(range * 2.0), (double)(range * 2.0));
        List entities = level.getEntities(owner, searchBox, predicate);
        for (Entity entity : entities) {
            if (owner instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)owner;
                entity.hurt(level.damageSources().mobAttack(living), damage);
                continue;
            }
            entity.hurt(level.damageSources().generic(), damage);
        }
        level.playSound(null, pos, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS);
    }

    public static void convertBlocks(ServerLevel level, Entity owner, BlockPos pos, double range, BlockState newState) {
        RandomSource random = RandomSource.create();
        int i = 0;
        while ((double)i <= 2.0 * range) {
            int j = 0;
            while ((double)j <= 2.0 * range) {
                int k = 0;
                while ((double)k <= 2.0 * range) {
                    double distance = Mth.sqrt((float)((float)(((double)i - range) * ((double)i - range) + ((double)j - range) * ((double)j - range) + ((double)k - range) * ((double)k - range))));
                    if (distance < range + 0.5) {
                        BlockState current;
                        BlockPos blockpos = pos.offset(i - (int)range, j - (int)range, k - (int)range);
                        if (EventHooks.canEntityGrief((Level)level, (Entity)owner) && random.nextFloat() < 0.2f && (current = level.getBlockState(blockpos)).isAir() && level.getBlockState(blockpos.below()).isSolidRender((BlockGetter)level, blockpos)) {
                            level.setBlock(blockpos, newState, 3);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static List<Item> helmetList() {
        ArrayList<Item> values = new ArrayList<Item>();
        for (String idString : (List)SConfig.SERVER.gas_masks.get()) {
            try {
                ResourceLocation id = ResourceLocation.tryParse((String)idString);
                if (id == null) continue;
                Optional optional = BuiltInRegistries.ITEM.getOptional(id);
                optional.ifPresent(values::add);
            }
            catch (Exception e) {
                System.err.println("[Spore] Invalid item ID in gas_masks config: " + idString);
            }
        }
        return values;
    }

    public static ItemStack tryToCreateStack(ResourceLocation location) {
        Optional optional = BuiltInRegistries.ITEM.getOptional(location);
        return optional.map(ItemStack::new).orElse(ItemStack.EMPTY);
    }

    public static EntityType<?> tryToCreateEntity(ResourceLocation location) {
        Optional optional = BuiltInRegistries.ENTITY_TYPE.getOptional(location);
        return optional.isEmpty() ? Sentities.KNIGHT.get() : (EntityType)optional.get();
    }

    public static Block tryToCreateBlock(ResourceLocation location) {
        Optional optional = BuiltInRegistries.BLOCK.getOptional(location);
        return optional.orElse(Blocks.AIR);
    }

    public static Holder<MobEffect> tryToCreateEffect(ResourceLocation location) {
        Optional<Holder<MobEffect>> optional = Optional.of(Utilities.wrapHolder((MobEffect)BuiltInRegistries.MOB_EFFECT.get(location)));
        return optional.orElse(Seffects.MYCELIUM);
    }

    public static Holder<Potion> tryToCreatePotion(ResourceLocation location) {
        if (location == null) {
            return Potions.AWKWARD;
        }
        try {
            Potion potion = (Potion)BuiltInRegistries.POTION.get(location);
            if (potion != null) {
                return BuiltInRegistries.POTION.wrapAsHolder((Object)potion);
            }
            return Potions.AWKWARD;
        }
        catch (Exception e) {
            return Potions.AWKWARD;
        }
    }

    public static Attribute tryToCreateAttribute(ResourceLocation location) {
        Optional optional = BuiltInRegistries.ATTRIBUTE.getOptional(location);
        return optional.orElse((Attribute)Attributes.ATTACK_KNOCKBACK.value());
    }

    public static List<Holder<Block>> tryToCreateBlockFromTag(Level level, ResourceLocation location) {
        TagKey tagKey;
        List<Object> values = new ArrayList<Holder<Block>>();
        HolderLookup.RegistryLookup blockGetter = level.registryAccess().lookupOrThrow(Registries.BLOCK);
        HolderSet.Named tagSet = blockGetter.get(tagKey = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)location)).orElse(null);
        if (tagSet == null) {
            return values;
        }
        values = tagSet.stream().toList();
        return values;
    }

    public static List<BlockState> biomass() {
        return biomass;
    }

    private static List<BlockState> createBiomass() {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        states.add(((Block)Sblocks.BIOMASS_BLOCK.get()).defaultBlockState());
        states.add(((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).defaultBlockState());
        states.add(((Block)Sblocks.CALCIFIED_BIOMASS_BLOCK.get()).defaultBlockState());
        states.add(((Block)Sblocks.MEMBRANE_BLOCK.get()).defaultBlockState());
        states.add(((Block)Sblocks.ROOTED_BIOMASS.get()).defaultBlockState());
        states.add(((Block)Sblocks.ROOTED_MYCELIUM.get()).defaultBlockState());
        states.add(((Block)Sblocks.GASTRIC_BIOMASS.get()).defaultBlockState());
        return states;
    }

    public static Vec3 generatePositionAway(Vec3 origin, double distance) {
        Random random = new Random();
        double theta = random.nextDouble() * 2.0 * Math.PI;
        double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
        double offsetX = Math.sin(phi) * Math.cos(theta) * distance;
        double offsetY = Math.sin(phi) * Math.sin(theta) * distance;
        double offsetZ = Math.cos(phi) * distance;
        return new Vec3(origin.x + offsetX, origin.y + offsetY, origin.z + offsetZ);
    }

    public static List<Item> getItemsFromTag(String namespace, String tagName) {
        TagKey tagKey = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)tagName));
        return BuiltInRegistries.ITEM.getTag(tagKey).map(holderSet -> holderSet.stream().map(Holder::value).collect(Collectors.toList())).orElse(List.of());
    }

    public static void doCustomModifiersAfterEffects(LivingEntity attacker, LivingEntity victim) {
        AttributeInstance grind;
        AttributeInstance local;
        AttributeInstance toxic;
        if (attacker == null || victim == null) {
            return;
        }
        AttributeInstance corrosion = attacker.getAttribute(SAttributes.CORROSIVES);
        if (corrosion != null && corrosion.getValue() >= 1.0) {
            int level = (int)corrosion.getValue() - 1;
            victim.addEffect(new MobEffectInstance(Seffects.CORROSION, 300, level), (Entity)attacker);
        }
        if ((toxic = attacker.getAttribute(SAttributes.TOXICITY)) != null && toxic.getValue() >= 1.0) {
            int level = (int)toxic.getValue() - 1;
            victim.addEffect(new MobEffectInstance(Holder.direct((Object)((MobEffect)MobEffects.POISON.value())), 400, level), (Entity)attacker);
        }
        if ((local = attacker.getAttribute(SAttributes.LOCALIZATION)) != null && local.getValue() >= 1.0) {
            int level = (int)local.getValue() - 1;
            victim.addEffect(new MobEffectInstance(Seffects.MARKER, 600, level), (Entity)attacker);
        }
        if ((grind = attacker.getAttribute(SAttributes.GRINDING)) != null && grind.getValue() >= 1.0) {
            double level = grind.getValue();
            victim.getArmorSlots().forEach(itemStack -> itemStack.setDamageValue(itemStack.getDamageValue() + (int)(10.0 * level)));
        }
    }

    public static int mixColors(Map<Integer, Float> colorsAndWeights) {
        float totalWeight = 0.0f;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (Map.Entry<Integer, Float> entry : colorsAndWeights.entrySet()) {
            int color = entry.getKey();
            float weight = entry.getValue().floatValue();
            r += (float)(color >> 16 & 0xFF) * weight;
            g += (float)(color >> 8 & 0xFF) * weight;
            b += (float)(color & 0xFF) * weight;
            totalWeight += weight;
        }
        if (totalWeight == 0.0f) {
            return 0xFFFFFF;
        }
        return (int)(r /= totalWeight) << 16 | (int)(g /= totalWeight) << 8 | (int)(b /= totalWeight);
    }

    public static Holder<MobEffect> wrapHolder(MobEffect effect) {
        return BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect);
    }
}

