/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Fluids;

import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;

public class BileLiquid
extends FluidType {
    public BileLiquid(FluidType.Properties properties) {
        super(properties);
    }

    public boolean canSwim(Entity entity) {
        return entity instanceof UtilityEntity || entity instanceof Infected;
    }

    public boolean canExtinguish(Entity entity) {
        return true;
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        if (entity instanceof UtilityEntity || entity instanceof Infected || entity instanceof TrueCalamity) {
            movementVector.scale(1.2);
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, 0.01, 0.0));
            entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 0, 40));
            gravity = 0.0;
        } else {
            movementVector.scale((double)0.4f);
            if (entity.tickCount % 40 == 0) {
                for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                    entity.addEffect(instance);
                }
                entity.hurt(entity.damageSources().generic(), 1.0f);
            }
        }
        return super.move(state, entity, movementVector, gravity);
    }

    public static List<MobEffectInstance> bileEffects() {
        ArrayList<MobEffectInstance> values = new ArrayList<MobEffectInstance>();
        values.add(new MobEffectInstance(MobEffects.WEAKNESS, 100, 0));
        values.add(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0));
        values.add(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 0));
        values.add(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 200, 0));
        return values;
    }
}

