/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Recipes;

import com.Harbinger.Spore.Recipes.GraftingRecipeInput;
import com.Harbinger.Spore.core.Srecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record GraftingRecipe(NonNullList<Ingredient> inputItems, ItemStack output) implements Recipe<GraftingRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        return this.inputItems;
    }

    public boolean matches(GraftingRecipeInput simpleContainer, Level level) {
        if (level.isClientSide() || simpleContainer.size() < 24) {
            return false;
        }
        for (int i = 21; i < 24; ++i) {
            if (((Ingredient)this.inputItems.get(i)).test(simpleContainer.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(GraftingRecipeInput craftingContainer, HolderLookup.Provider provider) {
        return this.output == null ? ItemStack.EMPTY : this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return Srecipes.GRAFTING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)Srecipes.GRAFTING_TYPE.get();
    }

    public static class GraftingRecipeSerializer
    implements RecipeSerializer<GraftingRecipe> {
        public static final GraftingRecipeSerializer INSTANCE = new GraftingRecipeSerializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"grafting");
        public static final MapCodec<GraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)SlottedIngredient.CODEC.codec().listOf().fieldOf("ingredients").xmap(list -> {
            NonNullList nonNullList = NonNullList.withSize((int)25, (Object)Ingredient.EMPTY);
            for (SlottedIngredient slotted : list) {
                int slot = Mth.clamp((int)slotted.slot(), (int)0, (int)24);
                nonNullList.set(slot, (Object)slotted.ingredient());
            }
            return nonNullList;
        }, ingredients -> ingredients.stream().map(ing -> new SlottedIngredient(ingredients.indexOf(ing), (Ingredient)ing)).toList()).forGetter(GraftingRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(GraftingRecipe::output)).apply((Applicative)inst, GraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GraftingRecipe> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, GraftingRecipe>(){

            public GraftingRecipe decode(RegistryFriendlyByteBuf buffer) {
                int size = buffer.readVarInt();
                NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
                for (int i = 0; i < size; ++i) {
                    inputs.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
                }
                ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
                return new GraftingRecipe((NonNullList<Ingredient>)inputs, result);
            }

            public void encode(RegistryFriendlyByteBuf buffer, GraftingRecipe recipe) {
                buffer.writeVarInt(recipe.inputItems().size());
                for (Ingredient ingredient : recipe.inputItems()) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
                }
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output());
            }
        };

        public MapCodec<GraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public record SlottedIngredient(int slot, Ingredient ingredient) {
        public static final MapCodec<SlottedIngredient> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("slot").forGetter(SlottedIngredient::slot), (App)Ingredient.CODEC_NONEMPTY.fieldOf("item").forGetter(SlottedIngredient::ingredient)).apply((Applicative)inst, SlottedIngredient::new));
    }
}

