/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Recipes;

import com.Harbinger.Spore.Recipes.SurgeryRecipeInput;
import com.Harbinger.Spore.core.Srecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record SurgeryRecipe(NonNullList<Ingredient> inputItems, ItemStack output) implements Recipe<SurgeryRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        return this.inputItems;
    }

    public boolean matches(SurgeryRecipeInput container, Level level) {
        if (level.isClientSide() || container.size() < 16) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            if (((Ingredient)this.inputItems.get(i)).test(container.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(SurgeryRecipeInput container, HolderLookup.Provider provider) {
        return this.output == null ? ItemStack.EMPTY : this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return Srecipes.SURGERY_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)Srecipes.SURGERY_TYPE.get();
    }

    public static class SurgeryRecipeSerializer
    implements RecipeSerializer<SurgeryRecipe> {
        public static final SurgeryRecipeSerializer INSTANCE = new SurgeryRecipeSerializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"surgery");
        public static final MapCodec<SurgeryRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)SlottedIngredient.CODEC.codec().listOf().fieldOf("ingredients").xmap(list -> {
            NonNullList nonNullList = NonNullList.withSize((int)16, (Object)Ingredient.EMPTY);
            for (SlottedIngredient slotted : list) {
                int slot = Mth.clamp((int)slotted.slot(), (int)0, (int)15);
                nonNullList.set(slot, (Object)slotted.ingredient());
            }
            return nonNullList;
        }, ingredients -> ingredients.stream().map(ing -> new SlottedIngredient(ingredients.indexOf(ing), (Ingredient)ing)).toList()).forGetter(SurgeryRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(SurgeryRecipe::output)).apply((Applicative)inst, SurgeryRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SurgeryRecipe> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SurgeryRecipe>(){

            public SurgeryRecipe decode(RegistryFriendlyByteBuf buffer) {
                int size = buffer.readVarInt();
                NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
                for (int i = 0; i < size; ++i) {
                    inputs.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
                }
                ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
                return new SurgeryRecipe((NonNullList<Ingredient>)inputs, result);
            }

            public void encode(RegistryFriendlyByteBuf buffer, SurgeryRecipe recipe) {
                buffer.writeVarInt(recipe.inputItems().size());
                for (Ingredient ingredient : recipe.inputItems()) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
                }
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output());
            }
        };

        public MapCodec<SurgeryRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SurgeryRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public record SlottedIngredient(int slot, Ingredient ingredient) {
        public static final MapCodec<SlottedIngredient> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("slot").forGetter(SlottedIngredient::slot), (App)Ingredient.CODEC_NONEMPTY.fieldOf("item").forGetter(SlottedIngredient::ingredient)).apply((Applicative)inst, SlottedIngredient::new));
    }
}

