/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.SBlockEntities.AnimatedEntity;
import com.Harbinger.Spore.Sentities.Utility.ArenaEntity;
import com.Harbinger.Spore.core.SblockEntities;
import com.Harbinger.Spore.core.Sentities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BrainRemnantBlockEntity
extends BlockEntity
implements AnimatedEntity {
    public int ticks;
    public int ticksOnFire = 0;
    private boolean onFire = false;

    public BrainRemnantBlockEntity(BlockPos pos, BlockState state) {
        super(SblockEntities.BRAIN_REMNANTS.get(), pos, state);
    }

    public BrainRemnantBlockEntity(BlockPos pos, BlockState state, boolean value) {
        super(SblockEntities.BRAIN_REMNANTS.get(), pos, state);
        this.setOnFire(value);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.setOnFire(tag.getBoolean("fire"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("fire", this.isOnFire());
    }

    public boolean isOnFire() {
        return this.onFire;
    }

    public void setOnFire(boolean time) {
        this.onFire = time;
    }

    public static <E extends BrainRemnantBlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, E e) {
        BrainRemnantBlockEntity.tickOnFire(level, pos, state, e);
    }

    public static <E extends BrainRemnantBlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, E e) {
        e.ticks = e.ticks <= 720 ? ++e.ticks : 0;
    }

    public static void tickOnFire(Level level, BlockPos pos, BlockState state, BrainRemnantBlockEntity entity) {
        if (entity.ticksOnFire > 0 && entity.isOnFire()) {
            ++entity.ticksOnFire;
            if (entity.ticksOnFire >= 50) {
                entity.ticksOnFire = 0;
                level.removeBlock(pos, false);
                level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2.0f, Level.ExplosionInteraction.NONE);
                ArenaEntity arenaEntity = new ArenaEntity(Sentities.ARENA_TENDRIL.get(), level);
                arenaEntity.moveTo(pos.getX(), pos.getY(), pos.getZ());
                arenaEntity.tickEmerging();
                arenaEntity.recalculateHosts();
                level.addFreshEntity((Entity)arenaEntity);
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }
}

