/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sblocks.CDUBlock;
import com.Harbinger.Spore.Screens.CDUMenu;
import com.Harbinger.Spore.Sentities.Utility.InfectionTendril;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SblockEntities;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CDUBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final TagKey<Block> foliage = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.parse((String)"removable_foliage"));
    public final int maxFuel;
    public int fuel;
    private final List<StoreDouble> blockMap;
    private final List<BlockState> biomass;

    public CDUBlockEntity(BlockPos pos, BlockState state) {
        super(SblockEntities.CDU.get(), pos, state);
        this.maxFuel = (Integer)SConfig.DATAGEN.cryo_time.get();
        this.blockMap = this.fabricateBlocks();
        this.biomass = this.stateList();
    }

    private List<StoreDouble> fabricateBlocks() {
        ArrayList<StoreDouble> blocks = new ArrayList<StoreDouble>();
        for (String str : (List)SConfig.DATAGEN.block_cleaning.get()) {
            String[] string = str.split("\\|");
            Block blockCon1 = Utilities.tryToCreateBlock(ResourceLocation.parse((String)string[0]));
            Block blockCon2 = Utilities.tryToCreateBlock(ResourceLocation.parse((String)string[1]));
            if (blockCon1 == Blocks.AIR || blockCon2 == Blocks.AIR) continue;
            blocks.add(new StoreDouble(blockCon1, blockCon2));
        }
        return blocks;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("fuel", this.getFuel());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.setFuel(tag.getInt("fuel"));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    public void setFuel(int i) {
        this.fuel = i;
    }

    public int getFuel() {
        return this.fuel;
    }

    public List<BlockState> stateList() {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        states.add(((Block)Sblocks.BIOMASS_BLOCK.get()).defaultBlockState());
        states.add(((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).defaultBlockState());
        states.add(((Block)Sblocks.CALCIFIED_BIOMASS_BLOCK.get()).defaultBlockState());
        states.add(((Block)Sblocks.MEMBRANE_BLOCK.get()).defaultBlockState());
        states.add(((Block)Sblocks.ROOTED_BIOMASS.get()).defaultBlockState());
        states.add(((Block)Sblocks.GASTRIC_BIOMASS.get()).defaultBlockState());
        states.add(((Block)Sblocks.ROOTED_MYCELIUM.get()).defaultBlockState());
        return states;
    }

    public void cleanInfection(BlockPos blockPos) {
        int range = 2 * (Integer)SConfig.DATAGEN.cryo_range.get();
        AABB aabb = AABB.ofSize((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (double)range, (double)range, (double)range);
        if (this.level == null) {
            return;
        }
        List entities = this.level.getEntitiesOfClass(LivingEntity.class, aabb);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState state = this.level.getBlockState(blockpos);
            if (state.is(foliage) && Math.random() < 0.2) {
                this.level.removeBlock(blockpos, false);
            }
            if (state == ((Block)Sblocks.REMAINS.get()).defaultBlockState()) {
                this.level.setBlock(blockpos, ((Block)Sblocks.FROZEN_REMAINS.get()).defaultBlockState(), 3);
            }
            if (Math.random() < 0.2 && !this.blockMap.isEmpty()) {
                for (StoreDouble storeDouble : this.blockMap) {
                    if (storeDouble.value1 != state.getBlock()) continue;
                    this.level.setBlock(blockpos, storeDouble.value2.defaultBlockState(), 3);
                }
            }
            if (Math.random() < 0.1) {
                if (this.biomass.contains(state)) {
                    this.level.setBlock(blockpos, ((Block)Sblocks.FROST_BURNED_BIOMASS.get()).defaultBlockState(), 3);
                }
                if (state == ((LiquidBlock)Sblocks.BILE.get()).defaultBlockState()) {
                    this.level.setBlock(blockpos, ((Block)Sblocks.CRUSTED_BILE.get()).defaultBlockState(), 3);
                }
            }
            if (!(Math.random() < 0.001) || !((Boolean)SConfig.DATAGEN.cryo_snow.get()).booleanValue()) continue;
            BlockState blockState1 = this.level.getBlockState(blockpos.above());
            if (!state.isSolidRender((BlockGetter)this.level, blockPos) || !blockState1.isAir()) continue;
            RandomSource randomSource = RandomSource.create();
            int layer = randomSource.nextInt(1, 4);
            BlockState snowState = Blocks.SNOW.defaultBlockState();
            Property property = snowState.getBlock().getStateDefinition().getProperty("layers");
            if (!(property instanceof IntegerProperty)) continue;
            IntegerProperty property2 = (IntegerProperty)property;
            this.level.setBlock(blockpos.above(), (BlockState)snowState.setValue((Property)property2, (Comparable)Integer.valueOf(layer)), 3);
        }
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
                livingEntity.setTicksFrozen(livingEntity.getTicksFrozen() + 100);
                float damage = CDUBlockEntity.getDamageAfterArmor((float)((Double)SConfig.DATAGEN.cryo_damage.get() * 1.0), livingEntity);
                livingEntity.hurt(livingEntity.damageSources().freeze(), damage);
            }
            if (!(entity instanceof ScentEntity) && !(entity instanceof InfectionTendril)) continue;
            entity.discard();
        }
    }

    public static float getDamageAfterArmor(float damage, LivingEntity target) {
        double armor = target.getArmorValue();
        AttributeInstance instance = target.getAttribute(Attributes.ARMOR_TOUGHNESS);
        double toughness = instance == null ? 0.0 : instance.getValue();
        float f = 2.0f + (float)toughness / 4.0f;
        float armorFactor = Math.min(20.0f, (float)armor);
        return damage * (1.0f - armorFactor / (armorFactor + f));
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, CDUBlockEntity e) {
        if (CDUBlock.isCDUUsable(blockPos, e.level) && e.getFuel() > 0 && !level.isClientSide) {
            --e.fuel;
            if (e.getFuel() % 100 == 0) {
                e.cleanInfection(blockPos);
            }
            if (e.getFuel() % 80 == 0) {
                level.playSound(null, blockPos, Ssounds.CDU_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.spore.cdu");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new CDUMenu(i, inventory);
    }

    record StoreDouble(Block value1, Block value2) {
    }
}

