/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.SBlockEntities.AnimatedEntity;
import com.Harbinger.Spore.Sentities.Organoids.Umarmer;
import com.Harbinger.Spore.Sentities.Organoids.Usurper;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SblockEntities;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OutpostWatcherBlockEntity
extends BlockEntity
implements AnimatedEntity {
    public int ticks;

    public OutpostWatcherBlockEntity(BlockPos pos, BlockState state) {
        super(SblockEntities.OUTPOST_WATCHER.get(), pos, state);
    }

    public void tick() {
        this.ticks = this.ticks <= 720 ? ++this.ticks : 0;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, OutpostWatcherBlockEntity e) {
        e.tick();
        if (e.getTicks() % 200 == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List players = serverLevel.players();
            if (players.isEmpty()) {
                return;
            }
            e.checkForPotentialTargets(level, blockPos);
        }
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, OutpostWatcherBlockEntity e) {
        e.tick();
    }

    public void checkForPotentialTargets(Level level, BlockPos blockPos) {
        if (level.getDifficulty() != Difficulty.PEACEFUL) {
            int range = 2 * (Integer)SConfig.DATAGEN.outpost_range.get();
            AABB aabb = AABB.ofSize((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (double)range, (double)range, (double)range);
            List possibleTargets = level.getEntitiesOfClass(LivingEntity.class, aabb);
            ArrayList<ScentEntity> amountofScents = new ArrayList<ScentEntity>();
            for (LivingEntity entity : possibleTargets) {
                if (!(entity instanceof ScentEntity)) continue;
                ScentEntity scent = (ScentEntity)entity;
                amountofScents.add(scent);
            }
            for (LivingEntity entity : possibleTargets) {
                if (!Utilities.TARGET_SELECTOR.Test(entity) || !EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity) || entity.hasEffect(Seffects.SYMBIOSIS) || !entity.onGround()) continue;
                if (Math.random() < (double)0.3f && amountofScents.size() <= (Integer)SConfig.SERVER.scent_cap.get()) {
                    this.SummonScent(entity, level, entity.getX(), entity.getY(), entity.getZ());
                }
                if (!(Math.random() < (double)0.1f) || !(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                this.SummonOrganoids(serverLevel, entity.getX(), entity.getY(), entity.getZ(), Math.random() <= 0.5, blockPos);
            }
        }
    }

    private void SummonScent(LivingEntity target, Level level, double x, double y, double z) {
        AABB aabb = target.getBoundingBox().inflate(3.0);
        List entityList = level.getEntities((Entity)target, aabb, entity -> {
            LivingEntity livingEntity;
            return entity instanceof LivingEntity && Utilities.TARGET_SELECTOR.Test(livingEntity = (LivingEntity)entity);
        });
        ScentEntity scent = new ScentEntity(Sentities.SCENT.get(), level);
        scent.setOvercharged(entityList.size() > 2);
        scent.moveTo(x, y, z);
        level.addFreshEntity((Entity)scent);
    }

    private void SummonOrganoids(ServerLevel level, double x, double y, double z, boolean range, BlockPos pos) {
        if (range) {
            Umarmer umarmer = new Umarmer(Sentities.UMARMED.get(), (Level)level);
            umarmer.moveTo(x, y, z);
            umarmer.teleportTo(x, y, z);
            umarmer.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(new BlockPos((Vec3i)pos)), MobSpawnType.MOB_SUMMONED, null);
            level.addFreshEntity((Entity)umarmer);
        } else {
            Usurper usurper = new Usurper(Sentities.USURPER.get(), (Level)level);
            usurper.moveTo(x, y, z);
            usurper.teleportTo(x, y, z);
            usurper.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(new BlockPos((Vec3i)pos)), MobSpawnType.MOB_SUMMONED, null);
            level.addFreshEntity((Entity)usurper);
        }
    }
}

