/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.SBlockEntities.AnimatedEntity;
import com.Harbinger.Spore.SBlockEntities.LivingStructureBlocks;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SblockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OvergrownSpawnerEntity
extends BlockEntity
implements AnimatedEntity {
    public int ticks;
    private int time;
    public final int maxTime = 1200;

    public OvergrownSpawnerEntity(BlockPos pos, BlockState state) {
        super(SblockEntities.OVERGROWN_SPAWNER.get(), pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("time", this.getTime());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.setTime(tag.getInt("time"));
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void addTime() {
        this.setTime(this.getTime() + 1);
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public static <E extends OvergrownSpawnerEntity> void serverTick(Level level, BlockPos pos, BlockState state, E e) {
        OvergrownSpawnerEntity.tick(level, pos, state, e);
    }

    public static <E extends OvergrownSpawnerEntity> void clientTick(Level level, BlockPos pos, BlockState state, E e) {
        OvergrownSpawnerEntity.tick(level, pos, state, e);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, OvergrownSpawnerEntity entity) {
        entity.ticks = entity.ticks <= 360 ? ++entity.ticks : 0;
        if (entity.getTime() <= entity.maxTime) {
            entity.addTime();
        } else {
            entity.setTime(0);
            entity.feed(level, pos);
        }
    }

    private void feed(Level level1, BlockPos blockPos) {
        int range = 2 * (Integer)SConfig.DATAGEN.spawner_range.get();
        AABB aabb = AABB.ofSize((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (double)range, (double)range, (double)range);
        List entities = level1.getEntitiesOfClass(LivingEntity.class, aabb);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockEntity blockEntity = level1.getBlockEntity(blockpos);
            if (!(blockEntity instanceof LivingStructureBlocks)) continue;
            LivingStructureBlocks structureBlocks = (LivingStructureBlocks)blockEntity;
            structureBlocks.addKills();
        }
        for (Entity entity : entities) {
            if (entity instanceof Infected) {
                Infected infected = (Infected)entity;
                infected.setKills(infected.getKills() + 1);
                infected.setEvolution(infected.getEvoPoints() + 1);
            }
            if (!(entity instanceof Calamity)) continue;
            Calamity calamity = (Calamity)entity;
            calamity.setKills(calamity.getKills() + 1);
        }
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }
}

