/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.Recipes.GraftingRecipe;
import com.Harbinger.Spore.Recipes.GraftingRecipeInput;
import com.Harbinger.Spore.Recipes.SurgeryRecipe;
import com.Harbinger.Spore.Recipes.SurgeryRecipeInput;
import com.Harbinger.Spore.Screens.SurgeryMenu;
import com.Harbinger.Spore.Sitems.Agents.MutationAgents;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorData;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import com.Harbinger.Spore.core.SblockEntities;
import com.Harbinger.Spore.core.Srecipes;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SurgeryTableBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(25);
    public final TagKey<Item> stringLikeItem = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"spore:stitches"));
    public static final int STRING_SLOT = 16;
    public static final int AGENT_SLOT_1 = 17;
    public static final int AGENT_SLOT_2 = 18;
    public static final int AGENT_SLOT_3 = 19;
    public static final int OUTPUT_SLOT = 20;
    public static final int GRATING_ITEM_ONE = 21;
    public static final int GRATING_INGREDIENT = 22;
    public static final int GRATING_ITEM_TWO = 23;
    public static final int GRATING_OUTPUT = 24;

    public SurgeryTableBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(SblockEntities.SURGERY_TABLE_ENTITY.get(), p_155229_, p_155230_);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"spore.surgery_table_menu");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory inventory, Player player) {
        return new SurgeryMenu(pContainerId, inventory, this);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public void drops() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)stack);
        }
    }

    public Optional<RecipeHolder<SurgeryRecipe>> getCurrentRecipe() {
        if (this.level == null || this.level.isClientSide()) {
            return Optional.empty();
        }
        ItemStack[] items = new ItemStack[16];
        for (int i = 0; i < 16; ++i) {
            items[i] = this.itemHandler.getStackInSlot(i);
        }
        return this.level.getRecipeManager().getRecipeFor((RecipeType)Srecipes.SURGERY_TYPE.get(), (RecipeInput)new SurgeryRecipeInput(items), this.level);
    }

    public void consumeItems() {
        Optional<RecipeHolder<SurgeryRecipe>> match = this.getCurrentRecipe();
        match.ifPresent(recipe -> {
            for (int i = 0; i < 16; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                this.itemHandler.extractItem(i, 1, false);
            }
            this.itemHandler.extractItem(16, 1, false);
        });
        if (this.level != null) {
            this.level.playLocalSound(this.getBlockPos(), Ssounds.SURGERY.get(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    public Optional<RecipeHolder<GraftingRecipe>> getCurrentGraftingRecipe() {
        ItemStack[] items = new ItemStack[25];
        for (int i = 0; i < 16; ++i) {
            items[i] = this.itemHandler.getStackInSlot(i);
        }
        return this.level.getRecipeManager().getRecipeFor((RecipeType)Srecipes.GRAFTING_TYPE.get(), (RecipeInput)new GraftingRecipeInput(items), this.level);
    }

    public void consumeItemsGrafting() {
        Optional<RecipeHolder<GraftingRecipe>> match = this.getCurrentGraftingRecipe();
        match.ifPresent(recipe -> {
            for (int i = 21; i < 24; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                this.itemHandler.extractItem(i, 1, false);
            }
        });
        if (this.level != null) {
            this.level.playLocalSound(this.getBlockPos(), Ssounds.SURGERY.get(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    public void assembleWeapon(Player player, ItemStack stack) {
        int mutation = 15;
        int[] e = new int[]{17, 18, 19};
        ArrayList<MutationAgents> mutagens = new ArrayList<MutationAgents>();
        for (int i : e) {
            ItemStack itemStack = this.itemHandler.getStackInSlot(i);
            Item item = itemStack.getItem();
            if (!(item instanceof MutationAgents)) continue;
            MutationAgents mutationAgents = (MutationAgents)item;
            mutagens.add(mutationAgents);
            itemStack.shrink(1);
        }
        if (stack.getItem() instanceof SporeWeaponData || stack.getItem() instanceof SporeArmorData) {
            Item item;
            Object item2;
            Item item3;
            Object object = mutagens.iterator();
            while (object.hasNext()) {
                MutationAgents mutagen = (MutationAgents)((Object)object.next());
                mutagen.mutateWeapon(stack);
                mutation += mutagen.getMutationChance();
            }
            if (Math.random() < (double)mutation * 0.01 && (item3 = stack.getItem()) instanceof SporeWeaponData) {
                item2 = (SporeWeaponData)item3;
                item2.setVariant(SporeToolsMutations.byId(player.getRandom().nextInt(SporeToolsMutations.values().length)), stack);
            }
            if (Math.random() < (double)mutation * 0.01 && (item = stack.getItem()) instanceof SporeArmorData) {
                item2 = (SporeArmorData)item;
                item2.setVariant(SporeArmorMutations.byId(player.getRandom().nextInt(SporeArmorMutations.values().length)), stack);
            }
            stack.setDamageValue(this.itemHandler.getStackInSlot(19) == ItemStack.EMPTY ? player.getRandom().nextInt(stack.getMaxDamage()) : 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    public ItemStack assembleGraft(ItemStack stack) {
        block9: {
            block8: {
                firstItem = this.itemHandler.getStackInSlot(21);
                secondItem = this.itemHandler.getStackInSlot(23);
                var5_4 = stack.getItem();
                if (!(var5_4 instanceof SporeWeaponData)) break block8;
                weaponData = (SporeWeaponData)var5_4;
                luck = 0;
                extra_durability = 0;
                extra_damage = 0.0;
                mutation = 0;
                var12_12 = firstItem.getItem();
                if (!(var12_12 instanceof SporeWeaponData)) ** GOTO lbl-1000
                firstWdata = (SporeWeaponData)var12_12;
                var12_12 = secondItem.getItem();
                if (var12_12 instanceof SporeWeaponData) {
                    secondWData = (SporeWeaponData)var12_12;
                    luck = (firstWdata.getLuck(firstItem) + secondWData.getLuck(secondItem)) / 2;
                    extra_durability = (firstWdata.getMaxAdditionalDurability(firstItem) + secondWData.getMaxAdditionalDurability(secondItem)) / 2;
                    extra_damage = (firstWdata.getAdditionalDamage(firstItem) + secondWData.getAdditionalDamage(secondItem)) / 2.0;
                    mutation = Math.random() < 0.5 ? firstWdata.getTypeVariant(firstItem) : secondWData.getTypeVariant(secondItem);
                } else lbl-1000:
                // 2 sources

                {
                    if ((var13_16 = firstItem.getItem()) instanceof SporeWeaponData) {
                        firstWdata = (SporeWeaponData)var13_16;
                        luck = firstWdata.getLuck(firstItem);
                        extra_durability = firstWdata.getMaxAdditionalDurability(firstItem);
                        extra_damage = firstWdata.getAdditionalDamage(firstItem);
                        mutation = firstWdata.getTypeVariant(firstItem);
                    }
                    if ((var13_16 = secondItem.getItem()) instanceof SporeWeaponData) {
                        secondWData = (SporeWeaponData)var13_16;
                        luck = secondWData.getLuck(secondItem);
                        extra_durability = secondWData.getMaxAdditionalDurability(secondItem);
                        extra_damage = secondWData.getAdditionalDamage(secondItem);
                        mutation = secondWData.getTypeVariant(secondItem);
                    }
                }
                weaponData.setLuck(luck, stack);
                weaponData.setMaxAdditionalDurability(extra_durability, stack);
                weaponData.setAdditionalDamage(extra_damage, stack);
                weaponData.setVariant(SporeToolsMutations.byId(mutation), stack);
            }
            if (!((luck = stack.getItem()) instanceof SporeArmorData)) break block9;
            armorData = (SporeArmorData)luck;
            luck = 0;
            extra_durability = 0;
            extra_protection = 0.0;
            agent_toughness = 0.0;
            mutation = 0;
            var14_17 = firstItem.getItem();
            if (!(var14_17 instanceof SporeArmorData)) ** GOTO lbl-1000
            firstWdata = (SporeArmorData)var14_17;
            var14_17 = secondItem.getItem();
            if (var14_17 instanceof SporeArmorData) {
                secondWData = (SporeArmorData)var14_17;
                luck = (firstWdata.getLuck(firstItem) + secondWData.getLuck(secondItem)) / 2;
                extra_durability = (firstWdata.getMaxAdditionalDurability(firstItem) + secondWData.getMaxAdditionalDurability(secondItem)) / 2;
                extra_protection = (firstWdata.getAdditionalProtection(firstItem) + secondWData.getAdditionalProtection(secondItem)) / 2.0;
                agent_toughness = (firstWdata.getAdditionalToughness(firstItem) + secondWData.getAdditionalToughness(secondItem)) / 2.0;
                mutation = Math.random() < 0.5 ? firstWdata.getTypeVariant(firstItem) : secondWData.getTypeVariant(secondItem);
            } else lbl-1000:
            // 2 sources

            {
                if ((var15_18 = firstItem.getItem()) instanceof SporeArmorData) {
                    firstWdata = (SporeArmorData)var15_18;
                    luck = firstWdata.getLuck(firstItem);
                    extra_durability = firstWdata.getMaxAdditionalDurability(firstItem);
                    extra_protection = firstWdata.getAdditionalProtection(firstItem);
                    agent_toughness = firstWdata.getAdditionalToughness(firstItem);
                    mutation = firstWdata.getTypeVariant(firstItem);
                }
                if ((var15_18 = secondItem.getItem()) instanceof SporeArmorData) {
                    secondWData = (SporeArmorData)var15_18;
                    luck = secondWData.getLuck(secondItem);
                    extra_durability = secondWData.getMaxAdditionalDurability(secondItem);
                    extra_protection = secondWData.getAdditionalProtection(secondItem);
                    agent_toughness = secondWData.getAdditionalToughness(secondItem);
                    mutation = secondWData.getTypeVariant(secondItem);
                }
            }
            armorData.setLuck(luck, stack);
            armorData.setMaxAdditionalDurability(extra_durability, stack);
            armorData.setAdditionalProtection(extra_protection, stack);
            armorData.setAdditionalToughness(agent_toughness, stack);
            armorData.setVariant(SporeArmorMutations.byId(mutation), stack);
        }
        return stack;
    }

    public boolean canInsertIntoOutputSlot(ItemStack stack, int slot) {
        ItemStack outputStack = this.itemHandler.getStackInSlot(slot);
        return outputStack.isEmpty();
    }

    public void updateOutputSlot() {
        if (this.itemHandler.getStackInSlot(16) == ItemStack.EMPTY) {
            this.itemHandler.setStackInSlot(20, ItemStack.EMPTY);
            return;
        }
        Optional<RecipeHolder<SurgeryRecipe>> match = this.getCurrentRecipe();
        if (match.isPresent()) {
            ItemStack stack = ((SurgeryRecipe)match.get().value()).getResultItem(null);
            if (this.canInsertIntoOutputSlot(stack, 20)) {
                this.itemHandler.insertItem(20, stack.copy(), false);
            }
        } else {
            this.itemHandler.setStackInSlot(20, ItemStack.EMPTY);
        }
    }

    public void updateSecondOutputSlot() {
        Optional<RecipeHolder<GraftingRecipe>> match = this.getCurrentGraftingRecipe();
        if (match.isPresent()) {
            ItemStack stack = ((GraftingRecipe)match.get().value()).getResultItem(null);
            if (this.canInsertIntoOutputSlot(stack, 24)) {
                this.itemHandler.insertItem(24, stack.copy(), false);
            }
        } else {
            this.itemHandler.setStackInSlot(24, ItemStack.EMPTY);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SurgeryTableBlockEntity entity) {
        entity.updateOutputSlot();
        entity.updateSecondOutputSlot();
    }
}

