/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.Sblocks.GenericFoliageBlock;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sitems;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BiomassBulb
extends GenericFoliageBlock {
    public BiomassBulb() {
        super(BlockBehaviour.Properties.of().strength(0.0f, 0.0f).noCollission().noOcclusion().sound(SoundType.SLIME_BLOCK));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return BiomassBulb.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0).move(offset.x, offset.y, offset.z);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (fluid.is((Fluid)Fluids.WATER)) {
            AreaEffectCloud cloud = new AreaEffectCloud(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            cloud.addEffect(new MobEffectInstance(Seffects.MARKER, 200, 0));
            level.addFreshEntity((Entity)cloud);
        } else {
            RandomSource randomSource = RandomSource.create();
            ItemStack stack = new ItemStack((ItemLike)Sitems.BIOMASS.get());
            stack.setCount(randomSource.nextInt(1, 5));
            ItemEntity entity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
            level.addFreshEntity((Entity)entity);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }
}

