/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.SBlockEntities.BiomassLumpEntity;
import com.Harbinger.Spore.SBlockEntities.LivingStructureBlocks;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.core.SConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BiomassLump
extends Block
implements EntityBlock {
    public BiomassLump() {
        super(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).sound(SoundType.SLIME_BLOCK).randomTicks().noOcclusion().noCollission());
    }

    public void onPlace(BlockState blockstate, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, level, pos, oldState, moving);
        level.scheduleTick(pos, (Block)this, 40);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource source) {
        BlockEntity entity = level.getBlockEntity(blockPos);
        level.scheduleTick(blockPos, (Block)this, 40);
        if (entity instanceof LivingStructureBlocks) {
            LivingStructureBlocks structureBlocks = (LivingStructureBlocks)entity;
            AABB searchbox = AABB.ofSize((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (double)33.0, (double)33.0, (double)33.0);
            List entities = level.getEntitiesOfClass(Infected.class, searchbox);
            for (Entity entity1 : entities) {
                Infected infected;
                if (!(entity1 instanceof Infected) || (infected = (Infected)entity1).getKills() <= 1 || structureBlocks.getKills() > (Integer)SConfig.DATAGEN.biomass_lump_kills.get()) continue;
                infected.setSearchPos(blockPos);
            }
            if (structureBlocks.getKills() >= (Integer)SConfig.DATAGEN.biomass_lump_kills.get()) {
                level.destroyBlock(blockPos, false);
                RandomSource random = RandomSource.create();
                if (Math.random() < 0.4) {
                    template = level.getStructureManager().getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"biomass_tower"));
                    pos = new BlockPos(blockPos.getX() - 3, blockPos.getY() - 2, blockPos.getZ() - 3);
                    template.placeInWorld((ServerLevelAccessor)level, pos, pos, new StructurePlaceSettings().setIgnoreEntities(true), random, 3);
                } else if (Math.random() < 0.4) {
                    template = level.getStructureManager().getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"biomass_tower_tall"));
                    pos = new BlockPos(blockPos.getX() - 3, blockPos.getY() - 1, blockPos.getZ() - 3);
                    template.placeInWorld((ServerLevelAccessor)level, pos, pos, new StructurePlaceSettings().setIgnoreEntities(true), random, 3);
                } else {
                    template = level.getStructureManager().getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"biomass_tower_small"));
                    pos = new BlockPos(blockPos.getX() - 2, blockPos.getY() - 1, blockPos.getZ() - 2);
                    template.placeInWorld((ServerLevelAccessor)level, pos, pos, new StructurePlaceSettings().setIgnoreEntities(true), random, 3);
                }
            }
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity livingEntity) {
        Infected infected;
        BlockEntity entity = level.getBlockEntity(pos);
        if (livingEntity instanceof Infected && (infected = (Infected)livingEntity).getKills() > 1 && entity.getPersistentData().getInt("kills") <= (Integer)SConfig.DATAGEN.biomass_lump_kills.get() && entity instanceof LivingStructureBlocks) {
            LivingStructureBlocks structureBlocks = (LivingStructureBlocks)entity;
            infected.setKills(infected.getKills() - 1);
            structureBlocks.addKills();
        }
        super.entityInside(state, level, pos, livingEntity);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BiomassLumpEntity(pos, state);
    }
}

