/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.SBlockEntities.BrainRemnantBlockEntity;
import com.Harbinger.Spore.core.SblockEntities;
import com.Harbinger.Spore.core.Ssounds;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BrainRemnants
extends BaseEntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final MapCodec<BrainRemnants> CODEC = BrainRemnants.simpleCodec(BrainRemnants::new);
    public static BlockBehaviour.Properties getDefaultProperties = BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(6.0f, 20.0f);

    public BrainRemnants(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BrainRemnantBlockEntity(pos, state, (Boolean)state.getValue((Property)LIT));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)LIT) != false ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return BrainRemnants.box((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)16.0, (double)15.9).move(offset.x, offset.y, offset.z);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState p_153274_, BlockEntityType<T> type) {
        return BrainRemnants.createBrainTicker(level, type, SblockEntities.BRAIN_REMNANTS.get());
    }

    @javax.annotation.Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createBrainTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends BrainRemnantBlockEntity> p_151990_) {
        return level.isClientSide ? BrainRemnants.createTickerHelper(type, p_151990_, BrainRemnantBlockEntity::clientTick) : BrainRemnants.createTickerHelper(type, p_151990_, BrainRemnantBlockEntity::serverTick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        super.createBlockStateDefinition(blockStateBuilder);
        blockStateBuilder.add(new Property[]{LIT});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof BrainRemnantBlockEntity) {
            BrainRemnantBlockEntity brainRemnantBlock = (BrainRemnantBlockEntity)entity;
            if (player.getItemInHand(hand).getItem() == Items.FLINT_AND_STEEL && !((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                level.setBlock(pos, (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
                brainRemnantBlock.setOnFire(true);
                brainRemnantBlock.ticksOnFire = 1;
                level.playSound(player, pos, Ssounds.BROKEN_SCREAMS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

