/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.SBlockEntities.CDUBlockEntity;
import com.Harbinger.Spore.core.SblockEntities;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.SdataComponents;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import org.jetbrains.annotations.Nullable;

public class CDUBlock
extends BaseEntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BlockBehaviour.Properties defaultProperties = BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(6.0f, 20.0f);
    public static final MapCodec<CDUBlock> CODEC = CDUBlock.simpleCodec(CDUBlock::new);

    public CDUBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CDUBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public static void replaceCDU(BlockPos pos, Level level) {
        if (level == null || level.isClientSide) {
            return;
        }
        BlockState blockState = level.getBlockState(pos);
        if (blockState.equals(((Block)Sblocks.CDU.get()).defaultBlockState())) {
            level.setBlock(pos, (BlockState)blockState.getBlock().defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public static boolean isCDUUsable(BlockPos pos, Level level) {
        if (level == null || level.isClientSide) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        if (!state.getBlock().equals(Sblocks.CDU.get())) {
            return true;
        }
        return (Boolean)state.getValue((Property)LIT) == false;
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource randomSource) {
        CDUBlockEntity blockEntity;
        super.animateTick(state, level, blockPos, randomSource);
        BlockEntity entity = level.getBlockEntity(blockPos);
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue() && entity instanceof CDUBlockEntity && (blockEntity = (CDUBlockEntity)entity).getFuel() > 0) {
            for (int i = 0; i < 360; ++i) {
                if (i % 20 != 0) continue;
                double yy = Math.sin(i) * Math.cos(i) * 0.25;
                level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, (double)blockPos.getX() + 0.47, (double)(blockPos.getY() + 1), (double)blockPos.getZ() + 0.47, Math.cos(i) * 0.15, yy, Math.sin(i) * 0.15);
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return CDUBlock.box((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)16.0, (double)15.9).move(offset.x, offset.y, offset.z);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        super.createBlockStateDefinition(blockStateBuilder);
        blockStateBuilder.add(new Property[]{LIT});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof CDUBlockEntity) {
            CDUBlockEntity blockEntity = (CDUBlockEntity)entity;
            ItemStack item = player.getItemInHand(hand);
            if (item.getItem() == Sitems.ICE_CANISTER.get()) {
                if (blockEntity.getFuel() > 0) {
                    player.displayClientMessage((Component)Component.literal((String)("Current fuel " + blockEntity.getFuel() + "/" + blockEntity.maxFuel)), true);
                } else {
                    level.playLocalSound(pos, Ssounds.CDU_INSERT.get(), SoundSource.BLOCKS, 2.0f, 2.0f, true);
                    level.playLocalSound(pos, Ssounds.CDU_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
                    blockEntity.setFuel(blockEntity.maxFuel);
                    item.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (player.isShiftKeyDown() && player instanceof ServerPlayer && !level.isClientSide) {
                player.openMenu((MenuProvider)blockEntity);
                NeoForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open(player, player.containerMenu));
                return ItemInteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.literal((String)("Current fuel " + blockEntity.getFuel() + "/" + blockEntity.maxFuel)), true);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState p_153274_, BlockEntityType<T> type) {
        return CDUBlock.createCDUTicker(level, type, SblockEntities.CDU.get());
    }

    public int getEntityFuel(Level level, BlockPos pos) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof CDUBlockEntity) {
            CDUBlockEntity blockEntity = (CDUBlockEntity)entity;
            return blockEntity.getFuel();
        }
        return 0;
    }

    @javax.annotation.Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createCDUTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends CDUBlockEntity> p_151990_) {
        return level.isClientSide ? null : CDUBlock.createTickerHelper(type, p_151990_, CDUBlockEntity::serverTick);
    }

    public void setFuelTag(ItemStack stack, int value) {
        stack.set(SdataComponents.CDU_FUEL, (Object)value);
    }

    public int getFuelTag(ItemStack stack) {
        return (Integer)stack.getOrDefault(SdataComponents.CDU_FUEL, (Object)0);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"cdu.line").withStyle(ChatFormatting.BLUE));
        tooltipComponents.add(((Item)Sitems.ICE_CANISTER.get()).getDescription());
        tooltipComponents.add((Component)Component.literal((String)(this.getFuelTag(stack) + "/12000")).withStyle(ChatFormatting.DARK_BLUE));
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setFuelTag(stack, this.getEntityFuel(level, pos));
        ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
        level.addFreshEntity((Entity)item);
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CDUBlockEntity) {
            CDUBlockEntity cduBlockEntity = (CDUBlockEntity)blockEntity;
            cduBlockEntity.setFuel((Integer)stack.getOrDefault(SdataComponents.CDU_FUEL, (Object)0));
        }
    }
}

