/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sblocks.GenericFoliageBlock;
import com.Harbinger.Spore.core.Sblocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingPlant
extends GenericFoliageBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    protected static final VoxelShape AABB = Shapes.or((VoxelShape)HangingPlant.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape HANGING_AABB = Shapes.or((VoxelShape)HangingPlant.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (VoxelShape)HangingPlant.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));

    public HangingPlant() {
        super(BlockBehaviour.Properties.of().strength(0.0f, 0.0f).noCollission().sound(SoundType.CROP).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HANGING, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_153467_) {
        FluidState fluidstate = p_153467_.getLevel().getFluidState(p_153467_.getClickedPos());
        for (Direction direction : p_153467_.getNearestLookingDirections()) {
            BlockState blockstate;
            if (direction.getAxis() != Direction.Axis.Y || !(blockstate = (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).canSurvive((LevelReader)p_153467_.getLevel(), p_153467_.getClickedPos())) continue;
            return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return null;
    }

    @Override
    public VoxelShape getShape(BlockState p_153474_, BlockGetter p_153475_, BlockPos p_153476_, CollisionContext p_153477_) {
        return (Boolean)p_153474_.getValue((Property)HANGING) != false ? HANGING_AABB : AABB;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_153490_) {
        p_153490_.add(new Property[]{HANGING, WATERLOGGED});
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        Direction direction = HangingPlant.getConnectedDirection(state).getOpposite();
        BlockState blockState = levelReader.getBlockState(pos.relative(direction));
        return blockState.canOcclude() || blockState.getBlock() == Sblocks.HANGING_FUNGAL_STEM.get();
    }

    protected static Direction getConnectedDirection(BlockState state) {
        return (Boolean)state.getValue((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    @Override
    public PushReaction getPistonPushReaction(BlockState p_153494_) {
        return PushReaction.DESTROY;
    }

    public BlockState updateShape(BlockState p_153483_, Direction p_153484_, BlockState p_153485_, LevelAccessor p_153486_, BlockPos p_153487_, BlockPos p_153488_) {
        if (((Boolean)p_153483_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_153486_.scheduleTick(p_153487_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_153486_));
        }
        return HangingPlant.getConnectedDirection(p_153483_).getOpposite() == p_153484_ && !p_153483_.canSurvive((LevelReader)p_153486_, p_153487_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_153483_, p_153484_, p_153485_, p_153486_, p_153487_, p_153488_);
    }

    @Override
    public FluidState getFluidState(BlockState p_153492_) {
        return (Boolean)p_153492_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_153492_);
    }

    @Override
    public boolean isPathfindable(BlockState p_153469_, BlockGetter p_153470_, BlockPos p_153471_, PathComputationType p_153472_) {
        return true;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && Utilities.TARGET_SELECTOR.Test(living = (LivingEntity)entity)) {
            entity.makeStuckInBlock(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!(level.isClientSide || entity.xOld == entity.getX() && entity.zOld == entity.getZ())) {
                double d0 = Math.abs(entity.getX() - entity.xOld);
                double d1 = Math.abs(entity.getZ() - entity.zOld);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    entity.hurt(entity.damageSources().cactus(), 1.0f);
                }
            }
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos blockpos, RandomSource randomSource) {
        if (Math.random() < 0.1) {
            BlockState block2 = ((Block)Sblocks.BLOOM_GG.get()).defaultBlockState();
            Property property = state.getBlock().getStateDefinition().getProperty("hanging");
            if (property instanceof BooleanProperty) {
                BooleanProperty property2 = (BooleanProperty)property;
                if (((Boolean)state.getValue((Property)property2)).booleanValue()) {
                    level.setBlock(blockpos, (BlockState)block2.setValue((Property)property2, (Comparable)Boolean.valueOf(true)), 3);
                } else {
                    level.setBlock(blockpos, block2, 3);
                }
            }
        }
        super.randomTick(state, level, blockpos, randomSource);
    }
}

