/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.Sblocks.HangingPlant;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class HangingPlantBub
extends HangingPlant {
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;

    public HangingPlantBub() {
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HANGING, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)PERSISTENT, (Comparable)Boolean.TRUE));
    }

    @Override
    public void entityInside(BlockState state, Level level, BlockPos blockpos, Entity entity) {
        if (!(level.isClientSide || entity instanceof Infected || entity instanceof UtilityEntity || ((List)SConfig.SERVER.blacklist.get()).contains(entity.getEncodeId()) || ((List)SConfig.SERVER.mycelium.get()).contains(entity.getEncodeId()))) {
            BlockState block2 = ((Block)Sblocks.BLOOM_G.get()).defaultBlockState();
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(level, (double)blockpos.getX() + 0.4, (double)blockpos.getY(), (double)blockpos.getZ() + 0.4);
            areaeffectcloud.setRadius(2.5f);
            areaeffectcloud.setRadiusOnUse(-0.5f);
            areaeffectcloud.setWaitTime(10);
            areaeffectcloud.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 100, 2));
            areaeffectcloud.setDuration(areaeffectcloud.getDuration() / 2);
            areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
            Property property = state.getBlock().getStateDefinition().getProperty("hanging");
            if (property instanceof BooleanProperty) {
                BooleanProperty property2 = (BooleanProperty)property;
                if (((Boolean)state.getValue((Property)property2)).booleanValue()) {
                    level.setBlock(blockpos, (BlockState)block2.setValue((Property)property2, (Comparable)Boolean.valueOf(true)), 3);
                } else {
                    level.setBlock(blockpos, block2, 3);
                }
            }
            level.addFreshEntity((Entity)areaeffectcloud);
            level.playSound(null, blockpos, Ssounds.FUNGAL_BURST.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)HANGING) != false && (Boolean)state.getValue((Property)PERSISTENT) != false;
    }

    @Override
    public void randomTick(BlockState state, ServerLevel level, BlockPos blockpos, RandomSource randomSource) {
        super.randomTick(state, level, blockpos, randomSource);
        if (Math.random() < (double)0.4f) {
            BlockState blockState = level.getBlockState(blockpos.below());
            BlockState blockState1 = level.getBlockState(blockpos.below(2));
            BlockState blockState2 = level.getBlockState(blockpos.below(3));
            if (blockState.getBlock() instanceof AirBlock && blockState1.getBlock() instanceof AirBlock && blockState2.getBlock() instanceof AirBlock) {
                BlockState block = ((Block)Sblocks.BLOOM_GG.get()).defaultBlockState();
                level.setBlock(blockpos, ((Block)Sblocks.HANGING_FUNGAL_STEM.get()).defaultBlockState(), 2);
                level.setBlock(blockpos.below(), (BlockState)((BlockState)block.setValue((Property)HANGING, (Comparable)Boolean.valueOf(true))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(!(Math.random() < 0.2))), 2);
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{HANGING, WATERLOGGED, PERSISTENT});
    }
}

