/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.SBlockEntities.HiveSpawnBlockEntity;
import com.Harbinger.Spore.SBlockEntities.LivingStructureBlocks;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SblockEntities;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HiveSpawn
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<HiveSpawn> CODEC = HiveSpawn.simpleCodec(HiveSpawn::new);
    public static final BlockBehaviour.Properties defaultProperties = BlockBehaviour.Properties.of().strength(4.0f, 4.0f).sound(SoundType.SLIME_BLOCK).randomTicks().noOcclusion().noCollission();

    public HiveSpawn(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HiveSpawnBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState blockState, boolean value) {
        super.onPlace(state, level, pos, blockState, value);
        level.scheduleTick(pos, (Block)this, 80);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource random) {
        BlockEntity entity = level.getBlockEntity(blockPos);
        level.scheduleTick(blockPos, (Block)this, 80);
        if (entity instanceof LivingStructureBlocks) {
            LivingStructureBlocks structureBlocks = (LivingStructureBlocks)entity;
            AABB searchbox = AABB.ofSize((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (double)50.0, (double)50.0, (double)50.0);
            List entities = level.getEntitiesOfClass(Infected.class, searchbox);
            for (Object entity1 : entities) {
                Infected infected;
                if (!(entity1 instanceof Infected) || (infected = (Infected)((Object)entity1)).getKills() <= 1 || structureBlocks.getKills() > (Integer)SConfig.DATAGEN.hive_spawn_kills.get()) continue;
                infected.setSearchPos(blockPos);
            }
            if (structureBlocks.getKills() >= (Integer)SConfig.DATAGEN.hive_spawn_kills.get() && this.checkForOtherMinds(blockPos, (Level)level)) {
                level.removeBlock(blockPos, true);
                Proto proto = (Proto)Sentities.PROTO.get().create((Level)level);
                if (proto != null) {
                    proto.tickEmerging();
                    proto.setPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                    proto.loadChunks();
                    if (((Boolean)SConfig.SERVER.teleport_hive.get()).booleanValue()) {
                        Proto.teleportToSurface(level, (Mob)proto);
                    }
                    level.addFreshEntity((Entity)proto);
                }
                for (ServerPlayer player : level.getServer().getPlayerList().getPlayers()) {
                    player.playNotifySound(Ssounds.REBIRTH.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                    player.displayClientMessage((Component)Component.translatable((String)"hivemind_summon_message"), false);
                }
            } else if (structureBlocks.getKills() >= (Integer)SConfig.DATAGEN.hive_spawn_kills.get() && !this.checkForOtherMinds(blockPos, (Level)level)) {
                StructureTemplate template = level.getStructureManager().getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"mega_biomass_tower"));
                BlockPos pos = new BlockPos(blockPos.getX() - 4, blockPos.getY() - 3, blockPos.getZ() - 4);
                template.placeInWorld((ServerLevelAccessor)level, pos, pos, new StructurePlaceSettings().setIgnoreEntities(true), random, 3);
            }
        }
    }

    boolean checkForOtherMinds(BlockPos blockPos, Level level) {
        int e = (Integer)SConfig.DATAGEN.hive_generate.get();
        AABB searchbox = AABB.ofSize((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (double)e, (double)e, (double)e);
        List entities = level.getEntitiesOfClass(Proto.class, searchbox);
        for (Entity entity1 : entities) {
            if (!(entity1 instanceof Proto)) continue;
            return false;
        }
        return true;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LivingStructureBlocks) {
            Infected infected;
            LivingStructureBlocks structureBlocks = (LivingStructureBlocks)blockEntity;
            if (entity instanceof Infected && (infected = (Infected)entity).getKills() > 1) {
                infected.setKills(infected.getKills() - 1);
                structureBlocks.addKills();
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        stateBuilder.add(new Property[]{WATERLOGGED});
    }

    public PushReaction getPistonPushReaction(BlockState p_153494_) {
        return PushReaction.PUSH_ONLY;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState p_153274_, BlockEntityType<T> type) {
        return HiveSpawn.createBrainTicker(level, type, SblockEntities.HIVE_SPAWN.get());
    }

    @javax.annotation.Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createBrainTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends HiveSpawnBlockEntity> p_151990_) {
        return level.isClientSide ? HiveSpawn.createTickerHelper(type, p_151990_, HiveSpawnBlockEntity::clientTick) : null;
    }
}

