/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.SBlockEntities.IncubatorBlockEntity;
import com.Harbinger.Spore.core.SblockEntities;
import com.Harbinger.Spore.core.SdataComponents;
import com.Harbinger.Spore.core.Sitems;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import org.jetbrains.annotations.Nullable;

public class IncubatorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<IncubatorBlock> CODEC = IncubatorBlock.simpleCodec(IncubatorBlock::new);
    public static final BlockBehaviour.Properties defaultProperties = BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(6.0f, 20.0f);

    public IncubatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new IncubatorBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return IncubatorBlock.box((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)16.0, (double)15.9).move(offset.x, offset.y, offset.z);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState p_153274_, BlockEntityType<T> type) {
        return IncubatorBlock.createIncubatorTicker(level, type, SblockEntities.INCUBATOR.get());
    }

    @javax.annotation.Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createIncubatorTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends IncubatorBlockEntity> p_151990_) {
        return level.isClientSide ? IncubatorBlock.createTickerHelper(type, p_151990_, IncubatorBlockEntity::clientTick) : IncubatorBlock.createTickerHelper(type, p_151990_, IncubatorBlockEntity::serverTick);
    }

    public BlockState rotate(BlockState p_54360_, Rotation p_54361_) {
        return (BlockState)p_54360_.setValue((Property)FACING, (Comparable)p_54361_.rotate((Direction)p_54360_.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState p_54357_, Mirror p_54358_) {
        return p_54357_.rotate(p_54358_.getRotation((Direction)p_54357_.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54370_) {
        p_54370_.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof IncubatorBlockEntity) {
            IncubatorBlockEntity blockEntity = (IncubatorBlockEntity)entity;
            ItemStack item = player.getItemInHand(hand);
            if (item.getItem() == Sitems.BIOMASS.get() && blockEntity.getFuel() <= 750) {
                blockEntity.setFuel(blockEntity.getFuel() + 250);
                item.shrink(1);
                return ItemInteractionResult.SUCCESS;
            }
            if (player.isShiftKeyDown() && player instanceof ServerPlayer) {
                player.openMenu((MenuProvider)blockEntity);
                NeoForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open(player, player.containerMenu));
                return ItemInteractionResult.SUCCESS;
            }
            if (blockEntity.getItem(0).isEmpty()) {
                if (item.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"spore:weapons")))) {
                    if (level.isClientSide) {
                        blockEntity.setItem(0, item.copy());
                    } else {
                        blockEntity.setItem(0, item.copy());
                        item.shrink(1);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                if (level.isClientSide) {
                    blockEntity.setItem(0, ItemStack.EMPTY);
                } else {
                    IncubatorBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)blockEntity.getItem(0).copy());
                    blockEntity.setItem(0, ItemStack.EMPTY);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void setFuelTag(ItemStack stack, int value) {
        stack.set(SdataComponents.INCUBATOR_FUEL, (Object)value);
    }

    public int getFuelTag(ItemStack stack) {
        return (Integer)stack.getOrDefault(SdataComponents.INCUBATOR_FUEL, (Object)0);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IncubatorBlockEntity) {
            IncubatorBlockEntity incubatorBlock = (IncubatorBlockEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)this);
            this.setFuelTag(stack, incubatorBlock.getFuel());
            ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
            level.addFreshEntity((Entity)item);
            IncubatorBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)incubatorBlock.getItem(0).copy());
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IncubatorBlockEntity) {
            IncubatorBlockEntity incubatorBlock = (IncubatorBlockEntity)blockEntity;
            incubatorBlock.setFuel(this.getFuelTag(stack));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        String string = Component.translatable((String)((Item)Sitems.BIOMASS.get()).getDescriptionId()).getString();
        tooltipComponents.add((Component)Component.literal((String)(string + " " + this.getFuelTag(stack) + "/1000")));
    }
}

