/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LabBedBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<TablePart> PART = EnumProperty.create((String)"part", TablePart.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<LabBedBlock> CODEC = LabBedBlock.simpleCodec(LabBedBlock::new);
    public static final BlockBehaviour.Properties defaultProperties = BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(6.0f, 20.0f);

    public LabBedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)TablePart.BOTTOM)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return Shapes.or((VoxelShape)LabBedBlock.box((double)0.1, (double)0.1, (double)0.1, (double)15.9, (double)15.9, (double)15.9), (VoxelShape[])new VoxelShape[0]);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos offsetPos;
        Direction facing = context.getHorizontalDirection();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (!level.getBlockState(offsetPos = pos.relative(facing)).canBeReplaced(context)) {
            return null;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(PART, (Comparable)((Object)TablePart.BOTTOM));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos otherPos = pos.relative(facing);
        BlockState otherState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(PART, (Comparable)((Object)TablePart.TOP));
        level.setBlock(otherPos, otherState, 3);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockPos otherPartPos;
            TablePart part = (TablePart)((Object)state.getValue(PART));
            Direction facing = (Direction)state.getValue((Property)FACING);
            BlockPos blockPos = otherPartPos = part == TablePart.BOTTOM ? pos.relative(facing) : pos.relative(facing.getOpposite());
            if (level.getBlockState(otherPartPos).getBlock() == this) {
                level.destroyBlock(otherPartPos, false);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, PART});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (state.getValue(PART) == TablePart.BOTTOM) {
            return super.getDrops(state, builder);
        }
        return Collections.emptyList();
    }

    public static enum TablePart implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private TablePart(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

