/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.core.Seffects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MembraneBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.1, (double)0.0, (double)16.0, (double)15.9, (double)16.0);

    public MembraneBlock() {
        super(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).sound(SoundType.SLIME_BLOCK).isSuffocating((p_61036_, p_61037_, p_61038_) -> false).isViewBlocking((p_61036_, p_61037_, p_61038_) -> false));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isAllowedToPass(LivingEntity livingEntity) {
        if (livingEntity instanceof Infected) return true;
        if (livingEntity instanceof UtilityEntity) {
            return true;
        }
        if (!(livingEntity instanceof Player)) return false;
        Player player = (Player)livingEntity;
        if (player.getAbilities().instabuild) return true;
        if (!player.hasEffect(Seffects.SYMBIOSIS)) return false;
        return true;
    }

    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public VoxelShape getBlockSupportShape(BlockState p_221566_, BlockGetter p_221567_, BlockPos p_221568_) {
        return Shapes.block();
    }

    public int getLightBlock(BlockState p_54460_, BlockGetter p_54461_, BlockPos p_54462_) {
        return 1;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        LivingEntity livingEntity;
        EntityCollisionContext entityCollisionContext;
        Entity entity;
        if (collisionContext instanceof EntityCollisionContext && (entity = (entityCollisionContext = (EntityCollisionContext)collisionContext).getEntity()) instanceof LivingEntity && this.isAllowedToPass(livingEntity = (LivingEntity)entity)) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, getter, pos, collisionContext);
    }

    public boolean isPathfindable(BlockState p_154258_, BlockGetter p_154259_, BlockPos p_154260_, PathComputationType p_154261_) {
        return true;
    }

    public void attack(BlockState p_60499_, Level p_60500_, BlockPos p_60501_, Player player) {
        player.addEffect(new MobEffectInstance(Seffects.SYMBIOSIS, 1200, 0));
        super.attack(p_60499_, p_60500_, p_60501_, player);
    }
}

