/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OrganiteBlock
extends Block {
    public OrganiteBlock() {
        super(BlockBehaviour.Properties.of().strength(6.0f, 4.0f).sound(SoundType.SLIME_BLOCK));
    }

    public void tick(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        super.tick(state, level, blockPos, randomSource);
        AABB searchbox = AABB.ofSize((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (double)35.0, (double)35.0, (double)35.0);
        List entities = level.getEntitiesOfClass(LivingEntity.class, searchbox);
        for (Entity entity1 : entities) {
            LivingEntity entity;
            if (!(entity1 instanceof LivingEntity) || (entity = (LivingEntity)entity1) instanceof Infected || entity instanceof UtilityEntity || ((List)SConfig.SERVER.blacklist.get()).contains(entity.getEncodeId()) || Utilities.helmetList().contains(entity.getItemBySlot(EquipmentSlot.HEAD).getItem())) continue;
            entity.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 200, 0));
            entity.addEffect(new MobEffectInstance(Seffects.MARKER, 400, 0));
        }
        level.scheduleTick(blockPos, (Block)this, 100);
    }

    public void onPlace(BlockState blockstate, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, level, pos, oldState, moving);
        level.scheduleTick(pos, (Block)this, 100);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        RandomSource random = RandomSource.create();
        for (String str : (List)SConfig.DATAGEN.organite_loot.get()) {
            int m;
            int maxV;
            String[] string = str.split("\\|");
            Item item1 = Utilities.tryToCreateStack(ResourceLocation.parse((String)string[0])).getItem();
            ItemStack itemStack = new ItemStack((ItemLike)item1);
            int minimalV = Integer.parseUnsignedInt(string[2]);
            if (minimalV == (maxV = Integer.parseUnsignedInt(string[3]))) {
                m = maxV;
            } else {
                try {
                    m = random.nextInt(minimalV, maxV);
                }
                catch (Exception e) {
                    m = 1;
                }
            }
            if (itemStack.equals(ItemStack.EMPTY) || !(Math.random() < (double)((float)Integer.parseUnsignedInt(string[1]) / 100.0f))) continue;
            itemStack.setCount(m);
            ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemStack);
            item.setPickUpDelay(10);
            level.addFreshEntity((Entity)item);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, false, fluid);
    }
}

