/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.SBlockEntities.OvergrownSpawnerEntity;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.core.SblockEntities;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sparticles;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OvergrownSpawner
extends BaseEntityBlock {
    public static final MapCodec<OvergrownSpawner> CODEC = OvergrownSpawner.simpleCodec(OvergrownSpawner::new);
    public static final BlockBehaviour.Properties defaultProperties = BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(6.0f, 20.0f);

    public OvergrownSpawner(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OvergrownSpawnerEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return OvergrownSpawner.createSpawnerTicker(level, type, SblockEntities.OVERGROWN_SPAWNER.get());
    }

    @javax.annotation.Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createSpawnerTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends OvergrownSpawnerEntity> p_151990_) {
        return level.isClientSide ? OvergrownSpawner.createTickerHelper(type, p_151990_, OvergrownSpawnerEntity::clientTick) : OvergrownSpawner.createTickerHelper(type, p_151990_, OvergrownSpawnerEntity::serverTick);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return OvergrownSpawner.box((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)16.0, (double)15.9).move(offset.x, offset.y, offset.z);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        OvergrownSpawnerEntity blockEntity;
        super.animateTick(state, level, pos, randomSource);
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof OvergrownSpawnerEntity && (blockEntity = (OvergrownSpawnerEntity)entity).getTime() > blockEntity.getMaxTime() - 60) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int l = 0; l < 10; ++l) {
                blockpos$mutableblockpos.set(pos.getX() + Mth.nextInt((RandomSource)randomSource, (int)-3, (int)3), pos.getY() + Mth.nextInt((RandomSource)randomSource, (int)-3, (int)3), pos.getZ() + Mth.nextInt((RandomSource)randomSource, (int)-3, (int)3));
                BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (blockstate.isSolidRender((BlockGetter)level, (BlockPos)blockpos$mutableblockpos)) continue;
                level.addParticle((ParticleOptions)Sparticles.BLOOD_PARTICLE.get(), (double)blockpos$mutableblockpos.getX() + randomSource.nextDouble(), (double)blockpos$mutableblockpos.getY() + randomSource.nextDouble(), (double)blockpos$mutableblockpos.getZ() + randomSource.nextDouble(), 0.0, 0.1, 0.0);
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        ScentEntity scent = new ScentEntity(Sentities.SCENT.get(), level);
        scent.setOvercharged(true);
        scent.moveTo(pos.getX(), pos.getY(), pos.getZ());
        level.addFreshEntity((Entity)scent);
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }
}

