/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.Sblocks.GenericFoliageBlock;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UnderWaterFungusTop
extends GenericFoliageBlock {
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;

    public UnderWaterFungusTop() {
        super(BlockBehaviour.Properties.of().sound(SoundType.CROP).strength(0.0f, 0.0f).noCollission().sound(SoundType.CROP).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.TRUE)).setValue((Property)PERSISTENT, (Comparable)Boolean.TRUE));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return UnderWaterFungusTop.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0).move(offset.x, offset.y, offset.z);
    }

    @Override
    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }

    @Override
    protected boolean mayPlaceOn(BlockState blockState, BlockGetter p_51043_, BlockPos pos) {
        return blockState.canOcclude() || blockState.getBlock() == Sblocks.UNDERWATER_FUNGAL_STEM.get();
    }

    public void entityInside(BlockState state, Level level, BlockPos blockpos, Entity entity) {
        if (!level.isClientSide) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(level, (double)blockpos.getX() + 0.4, (double)blockpos.getY(), (double)blockpos.getZ() + 0.4);
            areaeffectcloud.setRadius(3.5f);
            areaeffectcloud.setRadiusOnUse(-0.5f);
            areaeffectcloud.setWaitTime(10);
            areaeffectcloud.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 100, 0));
            areaeffectcloud.setDuration(areaeffectcloud.getDuration() / 2);
            areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
            level.addFreshEntity((Entity)areaeffectcloud);
            level.removeBlock(blockpos, false);
            level.playSound(null, blockpos, Ssounds.FUNGAL_BURST.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        super.randomTick(state, level, pos, source);
        BlockState blockState = level.getBlockState(pos.above());
        if (blockState.getFluidState().is((Fluid)Fluids.WATER)) {
            level.setBlock(pos, ((Block)Sblocks.UNDERWATER_FUNGAL_STEM.get()).defaultBlockState(), 3);
            BlockState block = ((Block)Sblocks.UNDERWATER_FUNGAL_STEM_TOP.get()).defaultBlockState();
            level.setBlock(pos.above(), (BlockState)block.setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(!(Math.random() < 0.3))), 3);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{WATERLOGGED, PERSISTENT});
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) != false && (Boolean)state.getValue((Property)WATERLOGGED) != false;
    }
}

