/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class VentPlateBlock
extends MultifaceBlock {
    public static final MapCodec<VentPlateBlock> CODEC = VentPlateBlock.simpleCodec(VentPlateBlock::new);

    public VentPlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MultifaceSpreader getSpreader() {
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockState blockState = level.getBlockState(pos.above());
        if (player.getPose() != Pose.SWIMMING && !player.isCrouching()) {
            if (blockState.isSolidRender((BlockGetter)level, pos.above())) {
                player.setPose(Pose.SWIMMING);
            }
            player.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return entity.isCrouching();
    }

    protected MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return context.getItemInHand().getItem() == this.asItem();
    }
}

