/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.Sblocks.GenericFoliageBlock;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallFolliage
extends GenericFoliageBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public WallFolliage() {
        super(BlockBehaviour.Properties.of().sound(SoundType.CROP).strength(0.0f, 0.0f).noCollission().noOcclusion().sound(SoundType.CROP));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter p_54373_, BlockPos p_54374_, CollisionContext p_54375_) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
        }
        return EAST_AABB;
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return entity instanceof Infected;
    }

    private boolean canAttachTo(BlockGetter p_54349_, BlockPos p_54350_, Direction p_54351_) {
        BlockState blockstate = p_54349_.getBlockState(p_54350_);
        return blockstate.isFaceSturdy(p_54349_, p_54350_, p_54351_);
    }

    @Override
    public boolean canSurvive(BlockState p_54353_, LevelReader p_54354_, BlockPos p_54355_) {
        Direction direction = (Direction)p_54353_.getValue((Property)FACING);
        return this.canAttachTo((BlockGetter)p_54354_, p_54355_.relative(direction.getOpposite()), direction);
    }

    public BlockState updateShape(BlockState p_54363_, Direction p_54364_, BlockState p_54365_, LevelAccessor p_54366_, BlockPos p_54367_, BlockPos p_54368_) {
        if (p_54364_.getOpposite() == p_54363_.getValue((Property)FACING) && !p_54363_.canSurvive((LevelReader)p_54366_, p_54367_)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)p_54363_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_54366_.scheduleTick(p_54367_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_54366_));
        }
        return super.updateShape(p_54363_, p_54364_, p_54365_, p_54366_, p_54367_, p_54368_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_54347_) {
        BlockState blockstate;
        if (!p_54347_.replacingClickedOnBlock() && (blockstate = p_54347_.getLevel().getBlockState(p_54347_.getClickedPos().relative(p_54347_.getClickedFace().getOpposite()))).is((Block)this) && blockstate.getValue((Property)FACING) == p_54347_.getClickedFace()) {
            return null;
        }
        BlockState blockstate1 = this.defaultBlockState();
        Level levelreader = p_54347_.getLevel();
        BlockPos blockpos = p_54347_.getClickedPos();
        FluidState fluidstate = p_54347_.getLevel().getFluidState(p_54347_.getClickedPos());
        for (Direction direction : p_54347_.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(blockstate1 = (BlockState)blockstate1.setValue((Property)FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return (BlockState)blockstate1.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return null;
    }

    public BlockState rotate(BlockState p_54360_, Rotation p_54361_) {
        return (BlockState)p_54360_.setValue((Property)FACING, (Comparable)p_54361_.rotate((Direction)p_54360_.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState p_54357_, Mirror p_54358_) {
        return p_54357_.rotate(p_54358_.getRotation((Direction)p_54357_.getValue((Property)FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54370_) {
        p_54370_.add(new Property[]{FACING, WATERLOGGED});
    }

    @Override
    public FluidState getFluidState(BlockState p_54377_) {
        return (Boolean)p_54377_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_54377_);
    }
}

