/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.SBlockEntities.ZoaholicBlockEntity;
import com.Harbinger.Spore.core.SblockEntities;
import com.Harbinger.Spore.core.Sitems;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZoaholicBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BlockBehaviour.Properties defaultProperties = BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(6.0f, 20.0f);
    public static final MapCodec<ZoaholicBlock> CODEC = ZoaholicBlock.simpleCodec(ZoaholicBlock::new);
    public static final String BIOMASS_KEY = "biomass";
    public static final String HEART_KEY = "heart";
    public static final String BRAIN_KEY = "brain";
    public static final String INNARDS_KEY = "innards";

    public ZoaholicBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ZoaholicBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return ZoaholicBlock.box((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)16.0, (double)15.9).move(offset.x, offset.y, offset.z);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof ZoaholicBlockEntity) {
            ZoaholicBlockEntity zoaholicBlock = (ZoaholicBlockEntity)entity;
            if (!zoaholicBlock.HasBrain() && stack.getItem() == Sitems.CEREBRUM.get()) {
                zoaholicBlock.setBrain(true);
                stack.shrink(1);
            } else if (!zoaholicBlock.HasHeart() && stack.getItem() == Sitems.MUTATED_HEART.get()) {
                zoaholicBlock.setHasHeart(true);
                stack.shrink(1);
            } else if (!zoaholicBlock.hasEnoughInnards() && stack.getItem() == Sitems.INNARDS.get()) {
                zoaholicBlock.setAmountOfInnards(zoaholicBlock.getAmountOfInnards() + 1);
                stack.shrink(1);
            } else if (zoaholicBlock.getBiomass() <= 9000 && stack.getItem() == Sitems.BIOMASS.get()) {
                zoaholicBlock.addBiomass(3000);
                stack.shrink(1);
            } else if (zoaholicBlock.isActive() && zoaholicBlock.getProcessing() <= 0) {
                zoaholicBlock.setProcessing(200);
            } else if (zoaholicBlock.HasHeart() && zoaholicBlock.hasEnoughInnards() && zoaholicBlock.HasBrain()) {
                String string = Component.translatable((String)((Item)Sitems.BIOMASS.get()).getDescriptionId()).getString();
                player.displayClientMessage((Component)Component.literal((String)(string + " " + zoaholicBlock.getBiomass() + "/12000")), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"zoaholic.line_1"), true);
            }
            if (player.isShiftKeyDown() && player instanceof ServerPlayer && !level.isClientSide) {
                player.openMenu((MenuProvider)zoaholicBlock);
                NeoForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open(player, player.containerMenu));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ZoaholicBlock.createCDUTicker(level, type, SblockEntities.ZOAHOLIC.get());
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createCDUTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends ZoaholicBlockEntity> blockEntityType) {
        return level.isClientSide ? ZoaholicBlock.createTickerHelper(type, blockEntityType, ZoaholicBlockEntity::clientTick) : ZoaholicBlock.createTickerHelper(type, blockEntityType, ZoaholicBlockEntity::serverTick);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, components, tooltipFlag);
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null) {
            boolean hasBrain = customData.copyTag().getBoolean(BRAIN_KEY);
            boolean hasHeart = customData.copyTag().getBoolean(HEART_KEY);
            int innards = customData.copyTag().getInt(INNARDS_KEY);
            int biomass = customData.copyTag().getInt(BIOMASS_KEY);
            if (hasBrain && hasHeart && innards >= 2) {
                String string = Component.translatable((String)((Item)Sitems.BIOMASS.get()).getDescriptionId()).getString();
                components.add((Component)Component.literal((String)(string + " " + biomass + "/12000")));
            } else {
                components.add((Component)Component.translatable((String)"zoaholic.line_2"));
                if (!hasBrain) {
                    components.add(((Item)Sitems.CEREBRUM.get()).getDescription());
                }
                if (!hasHeart) {
                    components.add(((Item)Sitems.MUTATED_HEART.get()).getDescription());
                }
                if (innards < 1) {
                    components.add(((Item)Sitems.INNARDS.get()).getDescription());
                }
                if (innards < 2) {
                    components.add(((Item)Sitems.INNARDS.get()).getDescription());
                }
            }
        } else {
            components.add((Component)Component.translatable((String)"zoaholic.line_2"));
            components.add(((Item)Sitems.CEREBRUM.get()).getDescription());
            components.add(((Item)Sitems.MUTATED_HEART.get()).getDescription());
            components.add(((Item)Sitems.INNARDS.get()).getDescription());
            components.add(((Item)Sitems.INNARDS.get()).getDescription());
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ZoaholicBlockEntity) {
            ZoaholicBlockEntity zoaholicBlockEntity = (ZoaholicBlockEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)this);
            CustomData tag = CustomData.EMPTY.update(t -> {
                t.putInt(BIOMASS_KEY, zoaholicBlockEntity.getBiomass());
                t.putBoolean(HEART_KEY, zoaholicBlockEntity.HasHeart());
                t.putBoolean(BRAIN_KEY, zoaholicBlockEntity.HasBrain());
                t.putInt(INNARDS_KEY, zoaholicBlockEntity.getAmountOfInnards());
            });
            stack.set(DataComponents.CUSTOM_DATA, (Object)tag);
            ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
            level.addFreshEntity((Entity)item);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ZoaholicBlockEntity) {
            ZoaholicBlockEntity zoaholicBlock = (ZoaholicBlockEntity)blockEntity;
            CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (customData != null) {
                CompoundTag tag = customData.copyTag();
                zoaholicBlock.setBiomass(tag.getInt(BIOMASS_KEY));
                zoaholicBlock.setAmountOfInnards(tag.getInt(INNARDS_KEY));
                zoaholicBlock.setHasHeart(tag.getBoolean(HEART_KEY));
                zoaholicBlock.setBrain(tag.getBoolean(BRAIN_KEY));
            }
        }
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

