/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Screens;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Recipes.SporeForcedRecipes.WombAssimilationRecipe;
import com.Harbinger.Spore.Screens.AssimilationMenu;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class AssimilationScreen
extends AbstractContainerScreen<AssimilationMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/gui/assimilation_gui.png");
    private final List<WombAssimilationRecipe.Recipe> recipes;
    private List<WombAssimilationRecipe.Pair> mobPairs;
    private int tickCounter = 0;
    private int currentItemIndex = 0;
    private Button leftButton;
    private Button rightButton;
    private int currentEntityIndex = 0;
    ClientLevel level;

    public AssimilationScreen(AssimilationMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.level = Minecraft.getInstance().level;
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.recipes = WombAssimilationRecipe.getWombAssimilationRecipes;
    }

    private void changeRecipe(int direction) {
        if (!this.recipes.isEmpty()) {
            this.currentItemIndex = (this.currentItemIndex + direction) % this.recipes.size();
            this.currentEntityIndex = 0;
            if (this.currentItemIndex < 0) {
                this.currentItemIndex += this.recipes.size();
            }
        }
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        int buttonY = this.topPos - 20;
        int buttonX = this.leftPos + 88;
        this.leftButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), button -> this.changeRecipe(-1)).bounds(buttonX - 10, buttonY, 20, 20).build());
        this.rightButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), button -> this.changeRecipe(1)).bounds(buttonX + 10, buttonY, 20, 20).build());
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        int x = this.leftPos + 34;
        int y = this.topPos + 70;
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        WombAssimilationRecipe.Recipe recipe = this.recipes.get(this.currentItemIndex);
        this.mobPairs = recipe.ids();
        if (this.level != null) {
            WombAssimilationRecipe.Pair pairs = this.mobPairs.get(this.currentEntityIndex);
            int variant = pairs.variant();
            ResourceLocation location = ResourceLocation.parse((String)pairs.id());
            Entity entity = Utilities.tryToCreateEntity(location).create((Level)this.level);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (living instanceof VariantKeeper) {
                    VariantKeeper keeper = (VariantKeeper)living;
                    keeper.setVariant(variant);
                    this.renderEntityInInventoryFollowsAngle(guiGraphics, x, y, 20, 0.0f, 0.0f, living);
                } else {
                    this.renderEntityInInventoryFollowsAngle(guiGraphics, x, y, 20, 0.0f, 0.0f, living);
                }
            }
        }
        this.renderIcon(guiGraphics, recipe.icon());
        this.renderName(guiGraphics, recipe.attribute());
    }

    private void renderIcon(GuiGraphics guiGraphics, ResourceLocation iconLocation) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconLocation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int iconX = this.leftPos + 100;
        int iconY = this.topPos + 30;
        int iconWidth = 32;
        int iconHeight = 32;
        guiGraphics.blit(iconLocation, iconX, iconY, 0.0f, 0.0f, iconWidth, iconHeight, iconWidth, iconHeight);
        RenderSystem.disableBlend();
    }

    private void renderName(GuiGraphics guiGraphics, String attributeName) {
        String[] strings = attributeName.split(":");
        MutableComponent name = Component.translatable((String)("attribute.name.spore." + strings[1]));
        int iconX = this.leftPos + 100;
        int iconY = this.topPos + 25;
        int iconWidth = 32;
        int textX = iconX + iconWidth / 2 - this.font.width((FormattedText)name) / 2;
        int textY = iconY - 10;
        guiGraphics.drawString(this.font, (Component)name, textX, textY, 0xFFFFFF, true);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }

    protected void containerTick() {
        super.containerTick();
        if (!this.recipes.isEmpty()) {
            ++this.tickCounter;
            if (this.tickCounter % 40 == 0) {
                this.currentEntityIndex = (this.currentEntityIndex + 1) % this.mobPairs.size();
            }
        }
    }
}

