/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Screens;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Screens.CDUMenu;
import com.Harbinger.Spore.Screens.TutorialMenuMethods;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sitems;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CDUScreen
extends AbstractContainerScreen<CDUMenu>
implements TutorialMenuMethods {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/gui/cdu_gui.png");
    private final List<StoreDouble> blockMap;
    private int tickCounter = 0;
    private int currentItemIndex = 0;

    public CDUScreen(CDUMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 176;
        this.imageHeight = 84;
        this.blockMap = this.fabricateBlocks();
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
    }

    private List<StoreDouble> fabricateBlocks() {
        ArrayList<StoreDouble> blocks = new ArrayList<StoreDouble>();
        for (String str : (List)SConfig.DATAGEN.block_cleaning.get()) {
            String[] string = str.split("\\|");
            Block blockCon1 = Utilities.tryToCreateBlock(ResourceLocation.parse((String)string[0]));
            Block blockCon2 = Utilities.tryToCreateBlock(ResourceLocation.parse((String)string[1]));
            if (blockCon1 == null || blockCon2 == null) continue;
            blocks.add(new StoreDouble(blockCon1, blockCon2));
        }
        return blocks;
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderFakeItem(this.font, guiGraphics, new ItemStack((ItemLike)Sitems.CDU.get()), this.leftPos + 79, this.topPos + 44);
        this.renderFakeItem(this.font, guiGraphics, new ItemStack((ItemLike)Sitems.ICE_CANISTER.get()), this.leftPos + 61, this.topPos + 62);
        if (!this.blockMap.isEmpty()) {
            this.renderFakeItem(this.font, guiGraphics, new ItemStack((ItemLike)this.blockMap.get((int)this.currentItemIndex).value1), this.leftPos + 34, this.topPos + 44);
            this.renderFakeItem(this.font, guiGraphics, new ItemStack((ItemLike)this.blockMap.get((int)this.currentItemIndex).value2), this.leftPos + 124, this.topPos + 44);
        }
    }

    protected void containerTick() {
        super.containerTick();
        if (!this.blockMap.isEmpty()) {
            ++this.tickCounter;
            if (this.tickCounter % 40 == 0) {
                this.currentItemIndex = (this.currentItemIndex + 1) % this.blockMap.size();
            }
        }
    }

    record StoreDouble(Block value1, Block value2) {
    }
}

