/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Screens;

import com.Harbinger.Spore.core.SMenu;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class CabinetMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;

    public CabinetMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)SMenu.CABINET_MENU.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.internal = new ItemStackHandler(18);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                byte hand = extraData.readByte();
                ItemStack itemstack = hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem();
                IItemHandler cap = (IItemHandler)itemstack.getCapability(Capabilities.ItemHandler.ITEM);
                if (cap != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else if (extraData.readableBytes() > 1) {
                IItemHandler cap;
                extraData.readByte();
                Entity boundEntity = this.world.getEntity(extraData.readVarInt());
                if (boundEntity != null && (cap = (IItemHandler)boundEntity.getCapability(Capabilities.ItemHandler.ENTITY)) != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else {
                BlockEntity boundBlockEntity = this.world.getBlockEntity(pos);
                if (boundBlockEntity instanceof BaseContainerBlockEntity) {
                    BaseContainerBlockEntity baseContainerBlockEntity = (BaseContainerBlockEntity)boundBlockEntity;
                    this.internal = new InvWrapper((Container)baseContainerBlockEntity);
                    this.bound = true;
                }
            }
        }
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 0, 7, 17){}));
        this.customSlots.put(1, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 1, 25, 17){}));
        this.customSlots.put(2, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 2, 43, 17){}));
        this.customSlots.put(3, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 3, 61, 17){}));
        this.customSlots.put(4, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 4, 79, 17){}));
        this.customSlots.put(5, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 5, 97, 17){}));
        this.customSlots.put(6, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 6, 115, 17){}));
        this.customSlots.put(7, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 7, 133, 17){}));
        this.customSlots.put(8, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 8, 151, 17){}));
        this.customSlots.put(9, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 9, 7, 53){}));
        this.customSlots.put(10, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 10, 25, 53){}));
        this.customSlots.put(11, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 11, 43, 53){}));
        this.customSlots.put(12, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 12, 61, 53){}));
        this.customSlots.put(13, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 13, 79, 53){}));
        this.customSlots.put(14, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 14, 97, 53){}));
        this.customSlots.put(15, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 15, 115, 53){}));
        this.customSlots.put(16, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 16, 133, 53){}));
        this.customSlots.put(17, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 17, 151, 53){}));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 8 + si * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 10) {
                if (!this.moveItemStackTo(itemstack1, 10, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 10, false)) {
                if (index < 37 ? !this.moveItemStackTo(itemstack1, 37, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 10, 37, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && !(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (maxSize = Math.min(slot.getMaxStackSize(), p_38904_.getMaxStackSize()))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        p_38904_.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (!(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    if (p_38904_.getCount() > slot1.getMaxStackSize()) {
                        slot1.set(p_38904_.split(slot1.getMaxStackSize()));
                    } else {
                        slot1.set(p_38904_.split(p_38904_.getCount()));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        block4: {
            super.removed(playerIn);
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    playerIn.drop(this.internal.extractItem(j, this.internal.getStackInSlot(j).getCount(), false), false);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    playerIn.getInventory().placeItemBackInInventory(this.internal.extractItem(i, this.internal.getStackInSlot(i).getCount(), false));
                }
            }
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

