/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Screens;

import com.Harbinger.Spore.Recipes.GraftingRecipe;
import com.Harbinger.Spore.Screens.GraftingRecipeMenu;
import com.Harbinger.Spore.Screens.TutorialMenuMethods;
import com.Harbinger.Spore.core.Srecipes;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;

public class GraftingRecipeScreen
extends AbstractContainerScreen<GraftingRecipeMenu>
implements TutorialMenuMethods {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"textures/gui/grafting_recipe_gui.png");
    private int currentItemIndex = 0;
    private Button leftButton;
    private Button rightButton;
    private final List<RecipeHolder<GraftingRecipe>> recipes;

    public GraftingRecipeScreen(GraftingRecipeMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 176;
        this.imageHeight = 84;
        ClientLevel level = Minecraft.getInstance().level;
        this.recipes = level == null ? new ArrayList<RecipeHolder<GraftingRecipe>>() : level.getRecipeManager().getAllRecipesFor((RecipeType)Srecipes.GRAFTING_TYPE.get());
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        int buttonY = this.topPos - 20;
        int buttonX = this.leftPos + 88;
        this.leftButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), button -> this.changeRecipe(-1)).bounds(buttonX - 10, buttonY, 20, 20).build());
        this.rightButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), button -> this.changeRecipe(1)).bounds(buttonX + 10, buttonY, 20, 20).build());
    }

    private void changeRecipe(int direction) {
        if (!this.recipes.isEmpty()) {
            this.currentItemIndex = (this.currentItemIndex + direction) % this.recipes.size();
            if (this.currentItemIndex < 0) {
                this.currentItemIndex += this.recipes.size();
            }
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        GraftingRecipe recipe = (GraftingRecipe)this.recipes.get(this.currentItemIndex).value();
        this.renderFakeItem(this.font, guiGraphics, this.getItemStackFromIngredient((Ingredient)recipe.getIngredients().get(21)), this.leftPos + 25, this.topPos + 8);
        this.renderFakeItem(this.font, guiGraphics, this.getItemStackFromIngredient((Ingredient)recipe.getIngredients().get(22)), this.leftPos + 25, this.topPos + 35);
        this.renderFakeItem(this.font, guiGraphics, this.getItemStackFromIngredient((Ingredient)recipe.getIngredients().get(23)), this.leftPos + 25, this.topPos + 62);
        ItemStack stack = recipe.getResultItem(null);
        this.renderFakeItem(this.font, guiGraphics, stack, this.leftPos + 88, this.topPos + 35);
    }

    private ItemStack getItemStackFromIngredient(Ingredient ingredient) {
        ItemStack[] itemStacks = ingredient.getItems();
        return itemStacks.length > 0 ? itemStacks[0] : ItemStack.EMPTY;
    }
}

