/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Screens;

import com.Harbinger.Spore.SBlockEntities.SurgeryTableBlockEntity;
import com.Harbinger.Spore.core.SMenu;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Sitems;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class SurgeryMenu
extends AbstractContainerMenu {
    public final SurgeryTableBlockEntity blockEntity;
    private final Level level;
    public static final ContainerData data = new SimpleContainerData(25);
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 20;

    public SurgeryMenu(int id, Inventory playerInventory, FriendlyByteBuf buf) {
        this(id, playerInventory, playerInventory.player.level().getBlockEntity(buf.readBlockPos()));
    }

    public SurgeryMenu(int pContainerId, Inventory inv, BlockEntity entity) {
        super((MenuType)SMenu.SURGERY_MENU.get(), pContainerId);
        SurgeryMenu.checkContainerSize((Container)inv, (int)25);
        this.blockEntity = (SurgeryTableBlockEntity)entity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), (BlockEntity)this.blockEntity, null);
        if (itemHandler == null) {
            return;
        }
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 0, 7, 8));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 1, 7, 26));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 2, 7, 44));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 3, 7, 62));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 4, 25, 8));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 5, 25, 26));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 6, 25, 44));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 7, 25, 62));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 8, 43, 8));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 9, 43, 26));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 10, 43, 44));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 11, 43, 62));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 12, 61, 8));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 13, 61, 26));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 14, 61, 44));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 15, 61, 62));
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 16, 97, 8){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.is(SurgeryMenu.this.blockEntity.stringLikeItem);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, itemHandler, 17, 115, 8){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == Sitems.HARDENING_AGENT.get();
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, itemHandler, 18, 133, 8){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == Sitems.SHARPENING_AGENT.get();
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, itemHandler, 19, 151, 8){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == Sitems.INTEGRATING_AGENT.get();
            }
        });
        this.addSlot((Slot)new SlotItemHandler(itemHandler, 20, 124, 53){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                SurgeryMenu.this.blockEntity.consumeItems();
                SurgeryMenu.this.blockEntity.assembleWeapon(player, stack);
            }
        });
        this.addDataSlots(data);
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        if (pIndex == 20) {
            return ItemStack.EMPTY;
        }
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 56, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 56) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player pPlayer) {
        return SurgeryMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)Sblocks.SURGERY_TABLE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public void removed(Player playerIn) {
        block4: {
            super.removed(playerIn);
            if (!(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                for (int j = 0; j < this.blockEntity.itemHandler.getSlots(); ++j) {
                    if (j == 20) continue;
                    playerIn.drop(this.blockEntity.itemHandler.extractItem(j, this.blockEntity.itemHandler.getStackInSlot(j).getCount(), false), false);
                }
            } else {
                for (int i = 0; i < this.blockEntity.itemHandler.getSlots(); ++i) {
                    if (i == 20) continue;
                    playerIn.getInventory().placeItemBackInInventory(this.blockEntity.itemHandler.extractItem(i, this.blockEntity.itemHandler.getStackInSlot(i).getCount(), false));
                }
            }
        }
    }
}

