/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.ScatterShotRangedGoal;
import com.Harbinger.Spore.Sentities.Calamities.Hinderburg;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;

public class AerialRangedGoal
extends ScatterShotRangedGoal {
    @Nullable
    protected Path path;
    protected final PathNavigation pathNav;

    public AerialRangedGoal(Hinderburg mob, double speed, int interval, float range, int min, int max) {
        super(mob, speed, interval, range, min, max);
        this.pathNav = mob.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public BlockPos getRandomPosition() {
        int x = this.mob.getBlockX() + this.mob.getRandom().nextInt(-20, 20);
        int y = this.mob.getOnPos().getY();
        int z = this.mob.getBlockZ() + this.mob.getRandom().nextInt(-20, 20);
        return new BlockPos(x, y, z);
    }

    @Override
    public boolean canUse() {
        if (this.target != null) {
            double d0 = this.mob.distanceToSqr((Entity)this.target);
            this.path = this.mob.getSensing().hasLineOfSight((Entity)this.target) && d0 < (double)this.attackRadiusSqr ? this.pathNav.createPath(this.getRandomPosition(), 16) : this.pathNav.createPath((Entity)this.target, 16);
        }
        return super.canUse();
    }

    @Override
    public void tick() {
        if (this.target != null) {
            double d0 = this.mob.distanceToSqr((Entity)this.target);
            boolean flag = this.mob.getSensing().hasLineOfSight((Entity)this.target);
            if (d0 / 4.0 < (double)this.attackRadiusSqr && d0 / 2.0 > (double)this.attackRadiusSqr) {
                this.Orbit(this.target);
            }
            if (this.mob.getY() < this.target.getY() + 8.0 || d0 / 2.0 < (double)this.attackRadiusSqr) {
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.1, 0.0));
            }
            this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
            if (--this.attackTime == 0) {
                Hinderburg hinderburg;
                Mob mob = this.mob;
                if (mob instanceof Hinderburg && (hinderburg = (Hinderburg)mob).tryToSummonNUKE((Entity)this.target)) {
                    hinderburg.tickBomb();
                }
                if (!flag) {
                    return;
                }
                RandomSource randomSource = RandomSource.create();
                int shot = randomSource.nextInt(this.minShots, this.maxShots + this.getExtraShots());
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
                for (int i = 0; i < shot; ++i) {
                    this.rangedAttackMob.performRangedAttack(this.target, f1);
                }
                this.attackTime = Mth.floor((float)(f * (float)this.attackInterval + (float)this.attackInterval));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackInterval, (double)this.attackInterval));
            }
        }
    }

    private void Orbit(LivingEntity target) {
        this.mob.setDeltaMovement(this.mob.getDeltaMovement().multiply(0.0, 1.0, 0.0).add(target.position().subtract(this.mob.position()).normalize().multiply(1.0, 0.0, 1.0).yRot(90.0f)).scale(this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * 1.5));
    }

    public void start() {
        if (this.mob.tickCount % 40 == 0) {
            this.mob.getNavigation().moveTo(this.path, this.speedModifier);
        }
        super.start();
    }
}

