/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import com.Harbinger.Spore.Sentities.AI.RangedBuff;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;

public class BuffAlliesGoal
extends Goal {
    protected final Level level;
    public final Mob mob;
    private final RangedBuff rangedAttackMob;
    private final TargetingConditions PARTNER_TARGETING;
    private final Class<? extends Mob> partnerClass;
    @Nullable
    protected Mob partner;
    private int attackTime = -1;
    private final double speedModifier;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;

    public BuffAlliesGoal(RangedBuff mob1, Class<? extends Mob> partnerClass, double speedModifier, int attackTime, int attackTime1, float attackRadius) {
        this(mob1, partnerClass, speedModifier, attackTime, attackTime1, attackRadius, null);
    }

    public BuffAlliesGoal(RangedBuff mob1, Class<? extends Mob> partnerClass, double speedModifier, int attackTime, int attackTime1, float attackRadius, @Nullable Predicate<LivingEntity> en) {
        this.partnerClass = partnerClass;
        if (!(mob1 instanceof LivingEntity)) {
            throw new IllegalArgumentException("Buff");
        }
        this.level = ((LivingEntity)mob1).level();
        this.rangedAttackMob = mob1;
        this.mob = (Mob)mob1;
        this.PARTNER_TARGETING = TargetingConditions.forNonCombat().range(this.mob.getAttributeBaseValue(Attributes.FOLLOW_RANGE)).selector(en);
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackTime;
        this.attackIntervalMax = attackTime1;
        this.attackRadius = attackRadius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.mob.getTarget() != null || this.getFreePartner() == null) {
            return false;
        }
        this.partner = this.getFreePartner();
        return this.partnerClass != null;
    }

    public boolean canContinueToUse() {
        return this.partner != null && (this.partner.isAlive() || this.getFreePartner() != null);
    }

    public void stop() {
        this.partner = null;
        this.attackTime = -1;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        assert (this.partner != null);
        double d0 = this.mob.distanceToSqr(this.partner.getX(), this.partner.getY(), this.partner.getZ());
        boolean flag = this.mob.getSensing().hasLineOfSight((Entity)this.partner);
        this.mob.getNavigation().moveTo((Entity)this.partner, this.speedModifier);
        this.mob.getLookControl().setLookAt((Entity)this.partner, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!flag) {
                return;
            }
            float f = (float)Math.sqrt(d0) / this.attackRadius;
            float f1 = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
            this.rangedAttackMob.performRangedBuff((LivingEntity)this.partner, f1);
            this.attackTime = Mth.floor((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }

    @Nullable
    private Mob getFreePartner() {
        List list = this.level.getNearbyEntities(this.partnerClass, this.PARTNER_TARGETING, (LivingEntity)this.mob, this.mob.getBoundingBox().inflate(this.mob.getAttributeBaseValue(Attributes.FOLLOW_RANGE)));
        double d0 = Double.MAX_VALUE;
        Mob inf = null;
        for (Mob inf1 : list) {
            if (!(this.mob.distanceToSqr((Entity)inf1) < d0)) continue;
            inf = inf1;
            d0 = this.mob.distanceToSqr((Entity)inf1);
        }
        return inf;
    }
}

