/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import com.Harbinger.Spore.Sentities.EvolvedInfected.Busser;
import com.Harbinger.Spore.core.SConfig;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class BusserFlyAndDrop
extends Goal {
    private final Busser busser;
    private final int high;
    public int tryTicks;

    public BusserFlyAndDrop(Busser busser, int high) {
        this.busser = busser;
        this.high = high;
    }

    public boolean canUse() {
        return this.busser.getTarget() != null && this.busser.isVehicle();
    }

    protected void moveMobToBlock() {
        this.busser.getNavigation().moveTo((double)((float)this.busser.getTarget().getX()) + 0.5, this.busser.getTarget().getY() + (double)this.high, (double)((float)this.busser.getTarget().getZ()) + 0.5, 1.0);
    }

    public void start() {
        if (this.busser.getTarget() != null) {
            this.moveMobToBlock();
        }
        this.tryTicks = 0;
        super.start();
    }

    public void tick() {
        super.tick();
        ++this.tryTicks;
        if (this.busser.getTarget() != null) {
            LivingEntity entity;
            if (this.busser.getSearchPos() != null && this.shouldRecalculatePath()) {
                this.busser.getNavigation().moveTo(this.busser.getTarget().getX(), this.busser.getTarget().getY() + (double)this.high, this.busser.getTarget().getZ(), 1.0);
            }
            if (Math.abs(Math.abs(this.busser.getX()) - Math.abs(this.busser.getTarget().getX())) < 3.0 && Math.abs(Math.abs(this.busser.getZ()) - Math.abs(this.busser.getTarget().getZ())) < 3.0 && (entity = (LivingEntity)this.busser.getFirstPassenger()) != null && ((List)SConfig.SERVER.can_be_carried.get()).contains(entity.getEncodeId())) {
                entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 200, 1));
                entity.stopRiding();
            }
        }
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

