/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI.CalamitiesAI;

import com.Harbinger.Spore.Sentities.Calamities.Gazenbrecher;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class GazenWaterLeapGoal
extends Goal {
    private final Gazenbrecher gazenbrecher;
    private LivingEntity target;

    public GazenWaterLeapGoal(Gazenbrecher p_25492_) {
        this.gazenbrecher = p_25492_;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        this.target = this.gazenbrecher.getTarget();
        if (this.target == null) {
            return false;
        }
        if (this.gazenbrecher.isInFluidType() && this.target.onGround() && !this.target.isInFluidType()) {
            double d0 = this.gazenbrecher.distanceToSqr((Entity)this.target);
            if (d0 > 32.0) {
                return this.gazenbrecher.getRandom().nextInt(GazenWaterLeapGoal.reducedTickDelay((int)50)) == 0;
            }
            return false;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.gazenbrecher.isInFluidType();
    }

    public void tick() {
        if (this.target != null) {
            this.gazenbrecher.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.gazenbrecher.getMaxHeadXRot());
        }
    }

    public void start() {
        Vec3 vec3 = this.gazenbrecher.getDeltaMovement();
        Vec3 vec31 = new Vec3(this.target.getX() - this.gazenbrecher.getX(), 0.0, this.target.getZ() - this.gazenbrecher.getZ());
        if (vec31.lengthSqr() > 1.0E-7) {
            vec31 = vec31.normalize().scale(2.0).add(vec3.scale(2.0));
        }
        this.gazenbrecher.setDeltaMovement(vec31.x, 1.3f, vec31.z);
    }
}

