/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI.CalamitiesAI;

import com.Harbinger.Spore.core.SAttributes;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class ScatterShotRangedGoal
extends Goal {
    protected final int minShots;
    protected final int maxShots;
    protected final Mob mob;
    protected final RangedAttackMob rangedAttackMob;
    @Nullable
    protected LivingEntity target;
    protected int attackTime = -1;
    protected final double speedModifier;
    protected int seeTime;
    protected final int attackInterval;
    protected final float attackRadius;
    protected final float attackRadiusSqr;

    public ScatterShotRangedGoal(RangedAttackMob mob, double speed, int interval, float range, int min, int max) {
        this.mob = (Mob)mob;
        this.rangedAttackMob = mob;
        this.speedModifier = speed;
        this.attackInterval = interval;
        this.attackRadius = range;
        this.attackRadiusSqr = range * range;
        this.minShots = min;
        this.maxShots = max;
    }

    public boolean canUse() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity != null) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse() || this.target != null && !this.mob.getNavigation().isDone();
    }

    public void stop() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public int getExtraShots() {
        AttributeInstance instance = this.mob.getAttribute(SAttributes.BALLISTIC);
        if (instance != null) {
            double level = instance.getValue();
            if (level < 1.0) {
                return 0;
            }
            return (int)(3.0 * level);
        }
        return 0;
    }

    public void tick() {
        double d0 = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean flag = this.mob.getSensing().hasLineOfSight((Entity)this.target);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
            this.mob.getNavigation().stop();
        } else {
            this.mob.getNavigation().moveTo((Entity)this.target, this.speedModifier);
        }
        this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!flag) {
                return;
            }
            RandomSource randomSource = RandomSource.create();
            int shot = randomSource.nextInt(this.minShots, this.maxShots + this.getExtraShots());
            float f = (float)Math.sqrt(d0) / this.attackRadius;
            float f1 = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
            for (int i = 0; i < shot; ++i) {
                this.rangedAttackMob.performRangedAttack(this.target, f1);
            }
            this.attackTime = Mth.floor((float)(f * (float)this.attackInterval + (float)this.attackInterval));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackInterval, (double)this.attackInterval));
        }
    }
}

