/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI.CalamitiesAI;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sblocks.CDUBlock;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;

public class SporeBurstSupport
extends Goal {
    private final Calamity calamity;

    public SporeBurstSupport(Calamity calamity) {
        this.calamity = calamity;
    }

    public boolean canUse() {
        return this.calamity.isAlive() && this.calamity.getRandom().nextInt(300) == 0 && this.calamity.getTarget() != null && this.calamity.distanceToSqr((Entity)this.calamity.getTarget()) < 200.0;
    }

    public void start() {
        this.calamity.setStun(60);
        Calamity calamity = this.calamity;
        if (calamity instanceof TrueCalamity) {
            TrueCalamity trueCalamity = (TrueCalamity)((Object)calamity);
            this.calamity.playSound(Ssounds.SPORE_BURST.get());
            AABB boundingBox = this.calamity.getBoundingBox().inflate((double)trueCalamity.chemicalRange());
            this.sporeBurst(trueCalamity.buffs(), trueCalamity.debuffs(), boundingBox);
            this.killCDUs(boundingBox);
        }
        super.start();
    }

    private void killCDUs(AABB aabb) {
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            if (!this.calamity.level().getBlockState(blockpos).is((Block)Sblocks.CDU.get())) continue;
            CDUBlock.replaceCDU(blockpos, this.calamity.level());
        }
    }

    private void sporeBurst(List<? extends String> buffs, List<? extends String> debuffs, AABB boundingBox) {
        this.calamity.playAmbientSound();
        List entities = this.calamity.level().getEntities((Entity)this.calamity, boundingBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            if (this.calamity.TARGET_SELECTOR.test(living) && !Utilities.helmetList().contains(living.getItemBySlot(EquipmentSlot.HEAD).getItem())) {
                this.applyEffects(living, debuffs);
            }
            if (!(living instanceof UtilityEntity) && !(living instanceof Infected)) continue;
            this.applyEffects(living, buffs);
            if (!(living instanceof Infected)) continue;
            Infected infected = (Infected)living;
            infected.setKills(infected.getKills() + this.calamity.getRandom().nextInt(4));
        }
    }

    private void applyEffects(LivingEntity living, List<? extends String> effects) {
        if (!effects.isEmpty()) {
            for (String string : effects) {
                String[] string2 = string.split("\\|");
                Holder<MobEffect> effect = Utilities.tryToCreateEffect(ResourceLocation.parse((String)string2[0]));
                if (living.hasEffect(effect)) continue;
                living.addEffect(new MobEffectInstance(effect, Integer.parseUnsignedInt(string2[1]), Integer.parseUnsignedInt(string2[2])));
            }
        }
    }
}

