/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.FlyingInfected;
import com.Harbinger.Spore.Sentities.WaterInfected;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.SwimNodeEvaluator;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class CalamityPathNavigation
extends GroundPathNavigation {
    protected final Calamity calamity;
    @Nullable
    private BlockPos pathToPosition;

    public CalamityPathNavigation(Calamity calamity, Level level) {
        super((Mob)calamity, level);
        this.calamity = calamity;
    }

    public Path createPath(BlockPos pos, int value) {
        this.pathToPosition = pos;
        return super.createPath(pos, value);
    }

    public Path createPath(Entity entity, int value) {
        this.pathToPosition = entity.blockPosition();
        return super.createPath(entity, value);
    }

    public boolean moveTo(Entity entity, double value) {
        Path path = this.createPath(entity, 0);
        if (path != null) {
            return this.moveTo(path, value);
        }
        this.pathToPosition = entity.blockPosition();
        this.speedModifier = value;
        return true;
    }

    protected boolean canMoveDirectly(Vec3 vec3, Vec3 vec31) {
        return CalamityPathNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)vec3, (Vec3)vec31, (boolean)true);
    }

    public void tick() {
        if (!this.isDone()) {
            super.tick();
        } else if (this.pathToPosition != null) {
            if (!(this.pathToPosition.closerToCenterThan((Position)this.mob.position(), Math.max((double)this.mob.getBbWidth(), 1.0)) || this.mob.getY() > (double)this.pathToPosition.getY() && new BlockPos(this.pathToPosition.getX(), (int)this.mob.getY(), this.pathToPosition.getZ()).closerToCenterThan((Position)this.mob.position(), Math.max((double)this.mob.getBbWidth(), 1.0)))) {
                this.mob.getMoveControl().setWantedPosition((double)this.pathToPosition.getX(), (double)this.pathToPosition.getY(), (double)this.pathToPosition.getZ(), this.speedModifier);
            } else {
                this.pathToPosition = null;
            }
        }
    }

    protected PathFinder createPathFinder(int value) {
        if (this.mob instanceof WaterInfected) {
            this.nodeEvaluator = new WaterCalamityNodeEvaluator();
            this.nodeEvaluator.setCanPassDoors(true);
            return new PathFinder(this, this.nodeEvaluator, value){

                protected float distance(Node node, Node node1) {
                    return node.distanceManhattan(node1);
                }
            };
        }
        if (this.mob instanceof FlyingInfected) {
            this.nodeEvaluator = new AirCalamityNodeEvaluator();
            this.nodeEvaluator.setCanPassDoors(true);
            return new PathFinder(this, this.nodeEvaluator, value){

                protected float distance(Node node, Node node1) {
                    return node.distanceManhattan(node1);
                }
            };
        }
        this.nodeEvaluator = new CalamityNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        this.nodeEvaluator.canFloat();
        return new PathFinder(this, this.nodeEvaluator, value){

            protected float distance(Node node, Node node1) {
                return node.distanceManhattan(node1);
            }
        };
    }

    public boolean isStuck() {
        this.recomputePath();
        return super.isStuck();
    }

    protected static class WaterCalamityNodeEvaluator
    extends SwimNodeEvaluator {
        public WaterCalamityNodeEvaluator() {
            super(true);
        }

        public PathType getPathType(PathfindingContext context, int x, int y, int z) {
            if (context.getPathTypeFromState(x, y, z).equals((Object)PathType.WATER)) {
                return PathType.WATER;
            }
            if (EventHooks.canEntityGrief((Level)this.mob.level(), (Entity)this.mob)) {
                return PathType.OPEN;
            }
            return super.getPathType(context, x, y, z);
        }
    }

    protected static class AirCalamityNodeEvaluator
    extends FlyNodeEvaluator {
        protected AirCalamityNodeEvaluator() {
        }

        public PathType getPathType(PathfindingContext context, int x, int y, int z) {
            if (EventHooks.canEntityGrief((Level)this.mob.level(), (Entity)this.mob)) {
                return PathType.OPEN;
            }
            return super.getPathType(context, x, y, z);
        }
    }

    protected static class CalamityNodeEvaluator
    extends WalkNodeEvaluator {
        protected CalamityNodeEvaluator() {
        }

        public PathType getPathType(PathfindingContext context, int x, int y, int z) {
            if (EventHooks.canEntityGrief((Level)this.mob.level(), (Entity)this.mob)) {
                return PathType.OPEN;
            }
            return super.getPathType(context, x, y, z);
        }
    }
}

