/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.phys.Vec3;

public class FlyingWanderAround
extends Goal {
    public PathfinderMob mob;
    public double speed;

    public FlyingWanderAround(PathfinderMob mob1, double speed) {
        this.mob = mob1;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.mob.getNavigation().isDone() && this.mob.tickCount % 40 == 0;
    }

    public boolean canContinueToUse() {
        return this.mob.getNavigation().isInProgress();
    }

    public void start() {
        Vec3 vec3 = this.findPos();
        if (vec3 != null) {
            this.mob.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, this.speed);
        }
    }

    @Nullable
    private Vec3 findPos() {
        Vec3 vec3 = this.mob.getViewVector(0.0f);
        Vec3 vec32 = HoverRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)7, (double)vec3.x, (double)vec3.z, (float)1.5707964f, (int)3, (int)1);
        return vec32 != null ? vec32 : AirAndWaterRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)4, (int)-2, (double)vec3.x, (double)vec3.z, (double)1.5707963705062866);
    }
}

