/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.SwimNodeEvaluator;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class HybridPathNavigation
extends GroundPathNavigation {
    @Nullable
    private BlockPos pathToPosition;

    public HybridPathNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    public Path createPath(BlockPos pos, int value) {
        this.pathToPosition = pos;
        return super.createPath(pos, value);
    }

    public Path createPath(Entity entity, int value) {
        this.pathToPosition = entity.blockPosition();
        return super.createPath(entity, value);
    }

    public boolean moveTo(Entity entity, double value) {
        Path path = this.createPath(entity, 0);
        if (path != null) {
            return this.moveTo(path, value);
        }
        this.pathToPosition = entity.blockPosition();
        this.speedModifier = value;
        return true;
    }

    protected boolean canMoveDirectly(Vec3 vec3, Vec3 vec31) {
        return HybridPathNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)vec3, (Vec3)vec31, (boolean)true);
    }

    public void tick() {
        if (!this.isDone()) {
            super.tick();
        } else if (this.pathToPosition != null) {
            if (!(this.pathToPosition.closerToCenterThan((Position)this.mob.position(), Math.max((double)this.mob.getBbWidth(), 1.0)) || this.mob.getY() > (double)this.pathToPosition.getY() && new BlockPos(this.pathToPosition.getX(), (int)this.mob.getY(), this.pathToPosition.getZ()).closerToCenterThan((Position)this.mob.position(), Math.max((double)this.mob.getBbWidth(), 1.0)))) {
                this.mob.getMoveControl().setWantedPosition((double)this.pathToPosition.getX(), (double)this.pathToPosition.getY(), (double)this.pathToPosition.getZ(), this.speedModifier);
            } else {
                this.pathToPosition = null;
            }
        }
        if (this.mob.tickCount % 10 == 0 && this.mob.getTarget() != null && this.mob.isInFluidType()) {
            this.UnderWaterLeaps(this.mob.getTarget());
        }
    }

    public void UnderWaterLeaps(LivingEntity target) {
        Vec3 vec3 = this.mob.getDeltaMovement();
        Vec3 vec31 = new Vec3(target.getX() - this.mob.getX(), target.getY() - this.mob.getY(), target.getZ() - this.mob.getZ());
        if (vec31.lengthSqr() > 1.0E-7) {
            vec31 = vec31.normalize().scale(0.5).add(vec3.scale(0.3));
        }
        this.mob.setDeltaMovement(vec31.x, vec31.y, vec31.z);
    }

    protected PathFinder createPathFinder(int value) {
        if (this.mob.isInFluidType()) {
            this.nodeEvaluator = new SwimmingNode();
            this.nodeEvaluator.setCanPassDoors(true);
            return new PathFinder(this, this.nodeEvaluator, value){

                protected float distance(Node node, Node node1) {
                    return node.distanceManhattan(node1);
                }
            };
        }
        this.nodeEvaluator = new WalkNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        return new PathFinder(this, this.nodeEvaluator, value){

            protected float distance(Node node, Node node1) {
                return node.distanceManhattan(node1);
            }
        };
    }

    public boolean isStuck() {
        this.recomputePath();
        return super.isStuck();
    }

    public boolean canFloat() {
        return this.mob.getAirSupply() < 60;
    }

    protected static class SwimmingNode
    extends SwimNodeEvaluator {
        public SwimmingNode() {
            super(true);
        }

        public PathType getPathType(PathfindingContext context, int x, int y, int z) {
            PathType path = context.getPathTypeFromState(x, y, z);
            if (path == PathType.WATER) {
                return PathType.WATER;
            }
            if (path == PathType.WALKABLE) {
                return PathType.OPEN;
            }
            if (EventHooks.canEntityGrief((Level)this.mob.level(), (Entity)this.mob)) {
                return PathType.BLOCKED;
            }
            return super.getPathType(context, x, y, z);
        }
    }
}

