/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Seffects;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class InfectedConsumeFromRemains
extends Goal {
    public Infected infected;

    public InfectedConsumeFromRemains(Infected infected) {
        this.infected = infected;
    }

    public boolean canUse() {
        return this.infected.isStarving() && this.infected.getRandom().nextInt(0, 10) == 0 && this.isCorpse((Entity)this.infected);
    }

    boolean isCorpse(Entity entity) {
        AABB aabb = entity.getBoundingBox().inflate(2.0);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState blockstate = this.infected.level().getBlockState(blockpos);
            if (blockstate.is((Block)Sblocks.REMAINS.get())) {
                if (Math.random() < 0.1) {
                    entity.level().removeBlock(blockpos, false);
                    this.infected.setHunger(0);
                    this.infected.setEvoPoints(this.infected.getEvoPoints() + 1);
                    this.infected.removeEffect(Seffects.STARVATION);
                }
                return true;
            }
            if (!blockstate.is((Block)Sblocks.BIOMASS_BULB.get())) continue;
            if (Math.random() < 0.1) {
                entity.level().removeBlock(blockpos, false);
                this.infected.setHunger(0);
                this.infected.setKills(this.infected.getKills() + 1);
                this.infected.removeEffect(Seffects.STARVATION);
            }
            return true;
        }
        return false;
    }

    public void start() {
        super.start();
        this.infected.playSound(SoundEvents.GENERIC_EAT);
    }
}

