/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.core.Sblocks;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class InfectedPanicGoal
extends Goal {
    protected final Infected mob;
    protected final double speedModifier;
    protected double posX;
    protected double posY;
    protected double posZ;

    public InfectedPanicGoal(Infected mob, double s) {
        this.mob = mob;
        this.speedModifier = s;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        BlockPos blockpos;
        if (!this.shouldPanic()) {
            return false;
        }
        if (this.mob.isOnFire()) {
            BlockPos blockpos2 = this.lookForWater((BlockGetter)this.mob.level(), (Entity)this.mob, 8);
            if (blockpos2 != null) {
                this.posX = blockpos2.getX();
                this.posY = blockpos2.getY();
                this.posZ = blockpos2.getZ();
                return true;
            }
        } else if (this.mob.isStarving() && (blockpos = this.lookForBodies((BlockGetter)this.mob.level(), (Entity)this.mob, 10)) != null) {
            this.posX = blockpos.getX();
            this.posY = blockpos.getY();
            this.posZ = blockpos.getZ();
            return true;
        }
        return this.findRandomPosition();
    }

    protected boolean shouldPanic() {
        return this.mob.isFreezing() || this.mob.isOnFire() || this.mob.isStarving() || this.mob.getLastDamageSource() == this.mob.damageSources().inWall();
    }

    protected boolean findRandomPosition() {
        Vec3 vec3 = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)5, (int)4);
        if (vec3 == null) {
            return false;
        }
        this.posX = vec3.x;
        this.posY = vec3.y;
        this.posZ = vec3.z;
        return true;
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.posX, this.posY, this.posZ, this.speedModifier);
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone();
    }

    @Nullable
    protected BlockPos lookForWater(BlockGetter getter, Entity entity, int distance) {
        BlockPos blockpos = entity.blockPosition();
        return !getter.getBlockState(blockpos).getCollisionShape(getter, blockpos).isEmpty() ? null : (BlockPos)BlockPos.findClosestMatch((BlockPos)entity.blockPosition(), (int)distance, (int)1, p_196649_ -> getter.getFluidState(p_196649_).is(FluidTags.WATER)).orElse(null);
    }

    @Nullable
    protected BlockPos lookForBodies(BlockGetter getter, Entity entity, int distance) {
        BlockPos blockpos = entity.blockPosition();
        return !getter.getBlockState(blockpos).getCollisionShape(getter, blockpos).isEmpty() ? null : (BlockPos)BlockPos.findClosestMatch((BlockPos)entity.blockPosition(), (int)distance, (int)1, p_196649_ -> getter.getBlockState(p_196649_).is((Block)Sblocks.REMAINS.get()) || getter.getBlockState(p_196649_).is((Block)Sblocks.BIOMASS_BULB.get())).orElse(null);
    }
}

