/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class LeapGoal
extends Goal {
    private final Mob mob;
    private LivingEntity target;
    private final float yd;

    public LeapGoal(Mob p_25492_, float p_25493_) {
        this.mob = p_25492_;
        this.yd = p_25493_;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        if (this.target == null) {
            return false;
        }
        if (this.mob.isInWater()) {
            return false;
        }
        double d0 = this.mob.distanceToSqr((Entity)this.target);
        if (d0 > 32.0) {
            if (!this.mob.onGround()) {
                return false;
            }
            return this.mob.getRandom().nextInt(LeapGoal.reducedTickDelay((int)5)) == 0;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.mob.onGround();
    }

    public void tick() {
        if (this.mob.getTarget() != null) {
            this.mob.getLookControl().setLookAt((Entity)this.mob.getTarget(), 10.0f, (float)this.mob.getMaxHeadXRot());
        }
    }

    public void start() {
        Vec3 vec3 = this.mob.getDeltaMovement();
        Vec3 vec31 = new Vec3(this.target.getX() - this.mob.getX(), 0.0, this.target.getZ() - this.mob.getZ());
        if (vec31.lengthSqr() > 1.0E-7) {
            vec31 = vec31.normalize().scale(2.0).add(vec3.scale(1.5));
        }
        this.mob.setDeltaMovement(vec31.x + (double)this.yd, (double)this.yd, vec31.z + (double)this.yd);
    }
}

