/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI.LocHiv;

import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class FollowOthersGoal
extends Goal {
    private static Predicate<LivingEntity> PARTNER_TARGETING;
    private final Infected infected;
    private final Class<? extends LivingEntity> desired_partner;

    public FollowOthersGoal(Infected infected, Class<? extends LivingEntity> desiredPartner, @Nullable Predicate<LivingEntity> en) {
        PARTNER_TARGETING = en;
        this.infected = infected;
        this.desired_partner = desiredPartner;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.infected.tickCount % 20 == 0) {
            if (this.infected.getFollowPartner() == null) {
                this.getFreePartner();
                return false;
            }
            return this.infected.getFollowPartner() != null;
        }
        return false;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canContinueToUse() {
        return this.infected.getFollowPartner() != null;
    }

    public void tick() {
        super.tick();
        if (this.infected.getFollowPartner() != null) {
            this.infected.getNavigation().moveTo((Entity)this.infected.getFollowPartner(), 1.0);
        }
    }

    @Nullable
    private LivingEntity getFreePartner() {
        List list = this.infected.level().getEntitiesOfClass(this.desired_partner, this.infected.getBoundingBox().inflate(32.0), PARTNER_TARGETING);
        double d0 = Double.MAX_VALUE;
        for (LivingEntity inf1 : list) {
            if (!(this.infected.distanceToSqr((Entity)inf1) < d0) || inf1 == this.infected) continue;
            this.infected.setFollowPartner(inf1);
            d0 = this.infected.distanceToSqr((Entity)inf1);
        }
        return null;
    }
}

