/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI.LocHiv;

import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import java.util.EnumSet;
import net.minecraft.core.Position;
import net.minecraft.world.entity.ai.goal.Goal;

public class SearchAreaGoal
extends Goal {
    public final Infected infected;
    public final double speed;
    public int tryTicks;

    public SearchAreaGoal(Infected infected1, double speed) {
        this.infected = infected1;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    protected void moveMobToBlock() {
        this.infected.getNavigation().moveTo((double)this.infected.getSearchPos().getX() + 0.5, (double)(this.infected.getSearchPos().getY() + 1), (double)this.infected.getSearchPos().getZ() + 0.5, 1.0);
    }

    public boolean canUse() {
        return this.infected.getSearchPos() != null && this.infected.getTarget() == null;
    }

    public void start() {
        this.moveMobToBlock();
        this.tryTicks = 0;
        super.start();
    }

    public boolean canContinueToUse() {
        return this.infected.getTarget() == null;
    }

    public void tick() {
        super.tick();
        ++this.tryTicks;
        if (this.infected.getSearchPos() != null && this.shouldRecalculatePath()) {
            this.infected.getNavigation().moveTo((double)this.infected.getSearchPos().getX(), (double)this.infected.getSearchPos().getY(), (double)this.infected.getSearchPos().getZ(), 1.0);
        }
        if (this.infected.getSearchPos() != null && this.infected.getSearchPos().closerToCenterThan((Position)this.infected.position(), 9.0)) {
            this.infected.setSearchPos(null);
        }
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

