/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;

public class TransportInfected<T extends LivingEntity>
extends Goal {
    public Mob mob;
    private final Class<T> partnerClass;
    protected final TargetingConditions partneerT;
    protected Level level;
    protected final double speed;
    @Nullable
    protected T partner;

    public TransportInfected(Mob mob, Class<T> partnerClass, double speed, @Nullable Predicate<LivingEntity> en) {
        this.mob = mob;
        this.level = mob.level();
        this.partnerClass = partnerClass;
        this.speed = speed;
        this.partneerT = TargetingConditions.forNonCombat().range(16.0).selector(en);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    @Nullable
    private T getFreePartner() {
        List list = this.level.getNearbyEntities(this.partnerClass, this.partneerT, (LivingEntity)this.mob, this.mob.getBoundingBox().inflate(32.0));
        double d0 = Double.MAX_VALUE;
        LivingEntity inf = null;
        for (LivingEntity inf1 : list) {
            if (!(this.mob.distanceToSqr((Entity)inf1) < d0)) continue;
            inf = inf1;
            d0 = this.mob.distanceToSqr((Entity)inf1);
        }
        return (T)inf;
    }

    public boolean canUse() {
        if (this.mob.tickCount % 20 == 0) {
            this.partner = this.getFreePartner();
        }
        return !this.mob.isVehicle() && this.mob.getTarget() == null && this.partner != null;
    }

    public void tick() {
        if (!this.mob.isVehicle() && this.partner != null && !this.partner.isPassenger()) {
            this.mob.getLookControl().setLookAt(this.partner, 10.0f, (float)this.mob.getMaxHeadXRot());
            this.mob.getNavigation().moveTo(this.partner, this.speed);
            if (this.mob.distanceToSqr(this.partner) < 9.0 && !this.partner.isPassenger()) {
                this.equip();
            }
        }
    }

    private void equip() {
        assert (this.partner != null);
        this.partner.startRiding((Entity)this.mob);
    }
}

