/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.ExtremelySusThings.ChunkLoaderHelper;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityVigilCall;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamityPathNavigation;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.MovementControls.CalamityMovementControl;
import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.Harbinger.Spore.Sentities.Utility.CorpseEntity;
import com.Harbinger.Spore.core.SAttributes;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.SdamageTypes;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sparticles;
import com.Harbinger.Spore.core.Ssounds;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Calamity
extends UtilityEntity
implements Enemy,
ArmorPersentageBypass {
    public static final EntityDataAccessor<Integer> KILLS = SynchedEntityData.defineId(Calamity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> MUTATION = SynchedEntityData.defineId(Calamity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<BlockPos> SEARCH_AREA = SynchedEntityData.defineId(Calamity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<Boolean> ROOTED = SynchedEntityData.defineId(Calamity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected int breakCounter;
    private int stun = 0;
    private static final List<BlockState> states = List.of(((Block)Sblocks.BIOMASS_BLOCK.get()).defaultBlockState(), ((Block)Sblocks.ROOTED_BIOMASS.get()).defaultBlockState(), ((Block)Sblocks.CALCIFIED_BIOMASS_BLOCK.get()).defaultBlockState(), ((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).defaultBlockState(), ((Block)Sblocks.REMAINS.get()).defaultBlockState());

    public Calamity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.navigation = new CalamityPathNavigation(this, level);
        this.moveControl = new CalamityMovementControl((Mob)this, 20);
        this.xpReward = 50;
    }

    protected int calculateFallDamage(float p_149389_, float p_149390_) {
        return super.calculateFallDamage(p_149389_, p_149390_) - 25;
    }

    public void setStun(int i) {
        this.stun = i;
    }

    public boolean isStunned() {
        return this.stun > 0;
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                Utilities.doCustomModifiersAfterEffects((LivingEntity)this, livingEntity);
                livingEntity.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600, 1), (Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.5) {
            return SdamageTypes.calamity_damage1((LivingEntity)this);
        }
        if (Math.random() < 0.5) {
            return SdamageTypes.calamity_damage2((LivingEntity)this);
        }
        return SdamageTypes.calamity_damage3((LivingEntity)this);
    }

    public void setTarget(@Nullable LivingEntity p_21544_) {
        super.setTarget(p_21544_);
        if (this.isRooted()) {
            this.setRooted(false);
        }
    }

    protected void tickPart(CalamityMultipart part, double e, double i, double o) {
        part.setPos(this.getX() + e, this.getY() + i, this.getZ() + o);
    }

    protected void tickPart(CalamityMultipart part, Vec3 vec3i) {
        Vec3 vec3 = vec3i.yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
        part.setPos(this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
    }

    protected void tickPart(CalamityMultipart part, Vec3 vec3i, double Y) {
        Vec3 vec3 = vec3i.yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
        part.setPos(this.getX() + vec3.x, this.getY() + Y, this.getZ() + vec3.z);
    }

    public void awardKillScore(Entity entity, int i, DamageSource damageSource) {
        AttributeInstance armor = this.getAttribute(Attributes.ARMOR);
        this.entityData.set(KILLS, (Object)((Integer)this.entityData.get(KILLS) + 1));
        if (this.canCalcify(entity) && armor != null) {
            armor.setBaseValue(armor.getValue() + 1.0);
        }
        super.awardKillScore(entity, i, damageSource);
    }

    public void travel(Vec3 p_32858_) {
        if (this.isEffectiveAi() && this.isInFluidType()) {
            this.moveRelative(0.1f, p_32858_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.7));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(p_32858_);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("kills", ((Integer)this.entityData.get(KILLS)).intValue());
        tag.putInt("mutation", ((Integer)this.entityData.get(MUTATION)).intValue());
        tag.putBoolean("rooted", ((Boolean)this.entityData.get(ROOTED)).booleanValue());
        tag.putInt("AreaX", this.getSearchArea().getX());
        tag.putInt("AreaY", this.getSearchArea().getY());
        tag.putInt("AreaZ", this.getSearchArea().getZ());
    }

    public void setMutationColor() {
        int value = this.colorMap().isEmpty() ? 0 : Utilities.mixColors(this.colorMap());
        this.entityData.set(MUTATION, (Object)value);
    }

    public int getMutationColor() {
        return (Integer)this.entityData.get(MUTATION);
    }

    Map<Integer, Float> colorMap() {
        HashMap<Integer, Float> values = new HashMap<Integer, Float>();
        float toxic = this.getAtLevel(this.getAttribute(SAttributes.TOXICITY));
        float rejuvenation = this.getAtLevel(this.getAttribute(SAttributes.REJUVENATION));
        float local = this.getAtLevel(this.getAttribute(SAttributes.LOCALIZATION));
        float laceration = this.getAtLevel(this.getAttribute(SAttributes.LACERATION));
        float corrosive = this.getAtLevel(this.getAttribute(SAttributes.CORROSIVES));
        float ballistic = this.getAtLevel(this.getAttribute(SAttributes.BALLISTIC));
        float grinding = this.getAtLevel(this.getAttribute(SAttributes.GRINDING));
        if (toxic > 0.0f) {
            values.put(-16751104, Float.valueOf(toxic));
        }
        if (rejuvenation > 0.0f) {
            values.put(-10092442, Float.valueOf(rejuvenation));
        }
        if (local > 0.0f) {
            values.put(-6711040, Float.valueOf(local));
        }
        if (laceration > 0.0f) {
            values.put(-65536, Float.valueOf(laceration));
        }
        if (corrosive > 0.0f) {
            values.put(-13369549, Float.valueOf(corrosive));
        }
        if (ballistic > 0.0f) {
            values.put(-10066330, Float.valueOf(ballistic));
        }
        if (grinding > 0.0f) {
            values.put(-16764058, Float.valueOf(grinding));
        }
        return values;
    }

    public float getAtLevel(AttributeInstance instance) {
        if (instance != null) {
            return (float)instance.getValue();
        }
        return 0.0f;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public void setSearchArea(BlockPos blockPos) {
        this.entityData.set(SEARCH_AREA, (Object)blockPos);
    }

    public BlockPos getSearchArea() {
        return (BlockPos)this.entityData.get(SEARCH_AREA);
    }

    public void setKills(Integer count) {
        this.entityData.set(KILLS, (Object)count);
    }

    public int getKills() {
        return (Integer)this.entityData.get(KILLS);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(KILLS, (Object)tag.getInt("kills"));
        this.entityData.set(MUTATION, (Object)tag.getInt("mutation"));
        this.entityData.set(ROOTED, (Object)tag.getBoolean("rooted"));
        int i = tag.getInt("AreaX");
        int j = tag.getInt("AreaY");
        int k = tag.getInt("AreaZ");
        this.setSearchArea(new BlockPos(i, j, k));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ROOTED, (Object)false);
        builder.define(KILLS, (Object)0);
        builder.define(MUTATION, (Object)0);
        builder.define(SEARCH_AREA, (Object)BlockPos.ZERO);
    }

    public boolean canCalcify(Entity entity) {
        return entity.getType().is(EntityTypeTags.SKELETONS);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isRooted() {
        return (Boolean)this.entityData.get(ROOTED);
    }

    public void setRooted(boolean value) {
        this.entityData.set(ROOTED, (Object)value);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new GoToLocation(this, 1.1));
        this.addTargettingGoals();
        this.goalSelector.addGoal(7, (Goal)new CalamityVigilCall(this));
    }

    public double getDamageCap() {
        return 0.0;
    }

    public boolean hurt(DamageSource source, float amount) {
        this.setRooted(false);
        if (this.getRandom().nextInt(20) == 0) {
            this.grief(this.getBoundingBox().inflate(this.setInflation(), 0.0, this.setInflation()));
        }
        if ((double)amount > this.getDamageCap() && this.getDamageCap() > 0.0) {
            return super.hurt(source, (float)this.getDamageCap());
        }
        if (source.is(DamageTypes.FREEZE) && Math.random() < (double)0.2f) {
            Calamity.forceStart(Calamity.findGoal((Mob)this, SporeBurstSupport.class));
        }
        return super.hurt(source, amount);
    }

    public static void forceStart(Goal goal) {
        try {
            Method m = Goal.class.getDeclaredMethod("start", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)goal, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T extends Goal> T findGoal(Mob mob, Class<T> goalClass) {
        for (WrappedGoal wrapped : mob.goalSelector.getAvailableGoals()) {
            if (!goalClass.isInstance(wrapped.getGoal())) continue;
            return (T)((Goal)goalClass.cast(wrapped.getGoal()));
        }
        return null;
    }

    public boolean tryToDigDown() {
        if (this.getSearchArea() != BlockPos.ZERO && this.verticalCollisionBelow) {
            double x = (double)Math.abs(this.getSearchArea().getX()) - Math.abs(this.getX());
            double z = (double)Math.abs(this.getSearchArea().getZ()) - Math.abs(this.getZ());
            return (double)this.getSearchArea().getY() < this.getY() && Math.abs(x) < 6.0 && Math.abs(z) < 6.0;
        }
        return false;
    }

    public void relocateExitPoint() {
        RandomSource randomSource = RandomSource.create();
        if ((double)this.getSearchArea().getY() > this.getY() && (double)Math.abs(this.getSearchArea().getX()) - Math.abs(this.getX()) < 6.0 && (double)Math.abs(this.getSearchArea().getZ()) - Math.abs(this.getZ()) < 6.0 && (double)Math.abs(this.getSearchArea().getY()) - Math.abs(this.getY()) > 4.0) {
            int f = (int)Math.abs((double)Math.abs(this.getSearchArea().getY()) - Math.abs(this.getY()));
            int x = randomSource.nextInt(-f, f);
            int z = randomSource.nextInt(-f, f);
            this.setSearchArea(new BlockPos(this.getSearchArea().getX() + x, this.getSearchArea().getY(), this.getSearchArea().getZ() + z));
        }
    }

    public double setInflation() {
        return 1.5;
    }

    public AABB getMiningHitbox() {
        if (this.getSearchArea() != BlockPos.ZERO && this.getTarget() == null) {
            if ((double)this.getSearchArea().getY() < this.getY()) {
                return this.getBoundingBox().inflate(this.setInflation(), 0.0, this.setInflation()).move(0.0, -1.0, 0.0);
            }
            if ((double)this.getSearchArea().getY() > this.getY()) {
                return this.getBoundingBox().inflate(this.setInflation(), 0.0, this.setInflation()).move(0.0, 1.0, 0.0);
            }
            return this.getBoundingBox().inflate(this.setInflation(), 0.0, this.setInflation());
        }
        return this.getBoundingBox().inflate(this.setInflation(), 0.0, this.setInflation()).move(0.0, 1.0, 0.0);
    }

    protected void grief(AABB aabb) {
        boolean flag = false;
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (Utilities.biomass().contains(blockstate)) {
                flag = this.level().setBlock(blockpos, ((Block)Sblocks.MEMBRANE_BLOCK.get()).defaultBlockState(), 3) || flag;
                this.breakCounter = 0;
                continue;
            }
            if (!(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) < (float)this.getDestroySpeed()) || !(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) >= 0.0f) || !EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) continue;
            flag = this.level().destroyBlock(blockpos, false, (Entity)this) || flag;
            this.breakCounter = 0;
        }
    }

    public void ActivateAdaptation() {
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.tickCount % 1200 == 0) {
            this.setRooted(this.getTarget() == null && (double)this.getHealth() <= (double)this.getMaxHealth() * 0.3 && this.onGround());
            if (this.isRooted()) {
                this.setKills(this.getKills() + 1);
            }
        }
        if (this.isRooted()) {
            this.makeStuckInBlock(Blocks.AIR.defaultBlockState(), new Vec3(0.0, 1.0, 0.0));
        }
        if (this.getRandom().nextInt(300) == 0 && this.getSearchArea() != BlockPos.ZERO) {
            this.relocateExitPoint();
        }
        if (this.breakCounter < 80) {
            ++this.breakCounter;
        } else if (this.getLastDamageSource() == this.damageSources().cactus() || this.getLastDamageSource() == this.damageSources().inWall() || this.horizontalCollision || this.tryToDigDown()) {
            this.grief(this.getMiningHitbox());
        }
        if (this.stun > 0 && this.onGround() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            --this.stun;
            this.makeStuckInBlock(Blocks.AIR.defaultBlockState(), new Vec3(0.0, 1.0, 0.0));
            double x0 = this.getX() - ((double)this.random.nextFloat() - 0.1) * 1.2;
            double y0 = this.getY() + ((double)this.random.nextFloat() - 0.25) * 1.25 * 5.0;
            double z0 = this.getZ() + ((double)this.random.nextFloat() - 0.1) * 1.2;
            serverLevel.sendParticles((ParticleOptions)Sparticles.BLOOD_PARTICLE.get(), x0, y0, z0, 4, 0.0, 0.0, 0.0, 1.0);
        }
        if (this.getHealth() < this.getMaxHealth() && !this.hasEffect(MobEffects.REGENERATION) && this.getKills() > 0) {
            int level2 = this.getHealth() < this.getMaxHealth() / 2.0f ? 1 : 0;
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 600, level2 + this.calculateHealing()));
            this.setKills(this.getKills() - 1);
        }
    }

    private int calculateHealing() {
        AttributeInstance toxic = this.getAttribute(SAttributes.REJUVENATION);
        if (toxic != null) {
            double level = toxic.getValue();
            if (level < 1.0) {
                return 0;
            }
            return (int)level;
        }
        return 0;
    }

    public int getDestroySpeed() {
        return (Integer)SConfig.SERVER.calamity_bd.get();
    }

    @Override
    public float amountOfDamage(float value) {
        AttributeInstance attack;
        double e;
        float extra = 0.0f;
        AttributeInstance penetration = this.getAttribute(SAttributes.LACERATION);
        if (penetration != null && (e = penetration.getValue()) >= 1.0) {
            extra = (float)(e * (double)0.1f);
        }
        return (attack = this.getAttribute(Attributes.ATTACK_DAMAGE)) == null ? value : (float)(attack.getValue() * (double)(0.2f + extra));
    }

    public void die(DamageSource source) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x0 = this.getX() - ((double)this.random.nextFloat() - 0.1) * 3.2;
            double y0 = this.getY() + ((double)this.random.nextFloat() - 0.25) * 3.25 * 5.0;
            double z0 = this.getZ() + ((double)this.random.nextFloat() - 0.1) * 3.2;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x0, y0, z0, 4, 0.0, 0.0, 0.0, 1.0);
        }
        this.playSound(Ssounds.CALAMITY_DEATH.get());
        super.die(source);
        this.summonBiomass();
        this.discard();
    }

    private void SummonMound(Entity entity) {
        Mound mound = new Mound(Sentities.MOUND.get(), entity.level());
        mound.moveTo(entity.getX(), entity.getY(), entity.getZ());
        mound.setMaxAge(4);
        entity.level().addFreshEntity((Entity)mound);
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.CALAMITY_DAMAGE.get();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setDefaultAdaptation(level);
        this.setMutationColor();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void setDefaultAdaptation(ServerLevelAccessor level) {
        ServerLevel serverLevel;
        SporeSavedData data;
        if (level instanceof ServerLevel && (data = SporeSavedData.getDataLocation(serverLevel = (ServerLevel)level)) != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get()) {
            this.ActivateAdaptation();
        }
    }

    public boolean addEffect(MobEffectInstance instance, @Nullable Entity entity) {
        if (((MobEffect)instance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL && instance.getAmplifier() < 1) {
            return false;
        }
        return super.addEffect(instance, entity);
    }

    public List<ItemStack> getDroppedItems(int val) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.getDropList() == null || this.getDropList().isEmpty()) {
            return drops;
        }
        for (String string : this.getDropList()) {
            int quantity;
            String[] parts = string.split("\\|");
            if (parts.length < 4) continue;
            ItemStack stack = Utilities.tryToCreateStack(ResourceLocation.parse((String)parts[0]));
            int minCount = Integer.parseUnsignedInt(parts[2]);
            int maxCount = Integer.parseUnsignedInt(parts[3]);
            int chancePercent = Integer.parseUnsignedInt(parts[1]) + val * 10;
            if (minCount == maxCount) {
                quantity = val > 0 ? this.random.nextInt(maxCount, maxCount + val) : maxCount;
            } else if (minCount >= 1 && maxCount >= 1) {
                float scale = 1.0f + 0.15f * (float)val;
                int adjustedMax = (int)((float)maxCount * scale);
                quantity = this.random.nextInt(minCount, adjustedMax + 1);
            } else {
                quantity = 1;
            }
            if (!(this.random.nextFloat() < (float)chancePercent / 100.0f)) continue;
            stack.setCount(quantity);
            drops.add(stack);
        }
        return drops;
    }

    public List<HitboxesForParts> parts() {
        return List.of();
    }

    public boolean getAdaptation() {
        return false;
    }

    @Override
    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        if (this.level().isClientSide()) {
            return;
        }
        int val = 0;
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            ItemStack weapon = attacker.getMainHandItem();
            Holder lootingHolder = attacker.level().holderOrThrow(Enchantments.LOOTING);
            val = weapon.getEnchantmentLevel(lootingHolder);
        }
        List<ItemStack> loot = this.getDroppedItems(val);
        List<HitboxesForParts> partList = this.parts();
        if (partList.isEmpty() || loot.isEmpty()) {
            return;
        }
        int partCount = partList.size();
        ArrayList<List<ItemStack>> distributedLoot = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < partCount; ++i) {
            distributedLoot.add(new ArrayList());
        }
        for (ItemStack stack : loot) {
            int baseAmount = stack.getCount() / partCount;
            int remainder = stack.getCount() % partCount;
            for (int i = 0; i < partCount; ++i) {
                int amount = baseAmount + (i < remainder ? 1 : 0);
                if (amount <= 0) continue;
                ((List)distributedLoot.get(i)).add(stack.copyWithCount(amount));
            }
        }
        this.summonCorpsePart(partCount, distributedLoot, partList);
    }

    public void summonCorpsePart(int partCount, List<List<ItemStack>> distributedLoot, List<HitboxesForParts> partList) {
        for (int i = 0; i < partCount; ++i) {
            CorpseEntity partEntity = new CorpseEntity(Sentities.CORPSE_PIECE.get(), this.level());
            for (ItemStack stack : distributedLoot.get(i)) {
                partEntity.addToInventory(stack);
            }
            partEntity.setColor(this.getMutationColor());
            partEntity.moveTo(this.position());
            partEntity.setDeltaMovement(new Vec3((this.random.nextDouble() - this.random.nextDouble()) * 0.9, this.random.nextDouble() * 0.6 + 0.3, (this.random.nextDouble() - this.random.nextDouble()) * 0.9));
            partEntity.setOwnerAda(this.getAdaptation());
            partEntity.setCorpseType(partList.get(i).getID());
            this.level().addFreshEntity((Entity)partEntity);
        }
    }

    public HitboxesForParts calculateChance(HitboxesForParts part, float val) {
        if (Math.random() < (double)val) {
            return part;
        }
        return null;
    }

    private void summonBiomass() {
        if (this.level().isClientSide) {
            return;
        }
        AABB aabb = this.getBoundingBox().inflate(1.0);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState blockState = this.level().getBlockState(blockpos);
            if (!blockState.isAir() || !(Math.random() < (double)0.1f)) continue;
            BlockState state = states.get(this.random.nextInt(states.size()));
            FallingBlockEntity.fall((Level)this.level(), (BlockPos)blockpos, (BlockState)state);
        }
    }

    public static class GoToLocation
    extends Goal {
        public final Calamity infected;
        public final double speed;
        public int tryTicks;

        public GoToLocation(Calamity infected1, double speed) {
            this.infected = infected1;
            this.speed = speed;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        protected void moveMobToBlock() {
            this.infected.getNavigation().moveTo((double)this.infected.getSearchArea().getX() + 0.5, (double)(this.infected.getSearchArea().getY() + 1), (double)this.infected.getSearchArea().getZ() + 0.5, 1.0);
        }

        public boolean canUse() {
            if (this.infected.getSearchArea() != BlockPos.ZERO && this.infected.getSearchArea() != null && this.infected.getTarget() == null) {
                return this.infected.getSearchArea().distToCenterSqr((Position)this.infected.position()) > 4.0;
            }
            return false;
        }

        public void start() {
            this.moveMobToBlock();
            this.tryTicks = 0;
            super.start();
        }

        public boolean canContinueToUse() {
            return this.infected.getTarget() == null;
        }

        public void tick() {
            super.tick();
            ++this.tryTicks;
            if (this.infected.getSearchArea() != BlockPos.ZERO && this.shouldRecalculatePath()) {
                this.moveMobToBlock();
            }
            if (this.infected.getSearchArea() != BlockPos.ZERO && this.infected.getSearchArea().distToCenterSqr((Position)this.infected.position()) < 80.0) {
                this.infected.setSearchArea(BlockPos.ZERO);
                this.infected.SummonMound((Entity)this.infected);
                ChunkPos chunk = this.infected.chunkPosition();
                UUID ownerId = this.infected.getUUID();
                String id = "calamity_" + String.valueOf(ownerId) + "_" + chunk.toString();
                ChunkLoaderHelper.removeRequest(id);
            }
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }
}

