/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EvolvedInfected
extends Infected {
    public EvolvedInfected(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        return super.blockBreakingParameter(blockstate, blockpos) || Utilities.biomass().contains(blockstate);
    }

    protected boolean canRide(Entity entity) {
        if (entity instanceof UtilityEntity) {
            return super.canRide(entity);
        }
        return false;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.level().getDifficulty() == Difficulty.HARD && (double)amount > this.getDamageCap() && ((Boolean)SConfig.SERVER.damagecap.get()).booleanValue()) {
            return super.hurt(source, (float)this.getDamageCap());
        }
        return super.hurt(source, amount);
    }

    public double getDamageCap() {
        return this.getMaxHealth() / 3.0f;
    }

    @Override
    public boolean canStarve() {
        return false;
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.EVOLVE_HURT.get();
    }

    @Override
    public boolean removeWhenFarAway(double p_21542_) {
        return this.getLinked() && !(this instanceof Scamper);
    }
}

