/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.BufferAI;
import com.Harbinger.Spore.Sentities.AI.LocHiv.SearchAreaGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.core.SConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Experiment
extends Infected {
    public static final EntityDataAccessor<Boolean> DORMANT = SynchedEntityData.defineId(Experiment.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Experiment(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public boolean canStarve() {
        return false;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("dormant", ((Boolean)this.entityData.get(DORMANT)).booleanValue());
    }

    public boolean isDormant() {
        return (Boolean)this.entityData.get(DORMANT);
    }

    public void setDormant(boolean value) {
        this.entityData.set(DORMANT, (Object)value);
        if (!value) {
            this.playSound(SoundEvents.CROP_BREAK);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DORMANT, (Object)tag.getBoolean("dormant"));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DORMANT, (Object)false);
    }

    @Override
    protected void addRegularGoals() {
        this.goalSelector.addGoal(3, (Goal)new BufferAI(this));
        this.goalSelector.addGoal(4, (Goal)new SearchAreaGoal(this, 1.2));
        this.goalSelector.addGoal(5, (Goal)new BufferAI(this));
        this.goalSelector.addGoal(6, (Goal)new FloatDiveGoal((Mob)this));
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        this.setDormant(false);
        return super.hurt(source, amount);
    }

    public void setTarget(@Nullable LivingEntity entity) {
        super.setTarget(entity);
        if (entity != null && this.isDormant()) {
            this.setDormant(false);
        }
    }

    public void tick() {
        super.tick();
        if (this.onGround() && this.isDormant()) {
            this.makeStuckInBlock(Blocks.AIR.defaultBlockState(), new Vec3(0.0, 1.0, 0.0));
        }
    }

    @Override
    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        float value = blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos);
        return this.tickCount % 20 == 0 && value > 0.0f && value <= (float)this.getBreaking();
    }

    public int getBreaking() {
        return (Integer)SConfig.SERVER.experiment_bd.get();
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.NATURAL) {
            this.setDormant(true);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }
}

