/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.Calamities.Hohlfresser;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidType;

public class HohlMultipart
extends LivingEntity
implements TrueCalamity {
    private double prevHeight = 0.0;
    private int headEntityId = -1;
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.defineId(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.defineId(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_TAIL = SynchedEntityData.defineId(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> PARENT_ID = SynchedEntityData.defineId(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private float spin = 0.0f;

    public HohlMultipart(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.CALAMITY_DAMAGE.get();
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CHILD_UUID, Optional.empty());
        builder.define(PARENT_UUID, Optional.empty());
        builder.define(SIZE, (Object)Float.valueOf(1.0f));
        builder.define(VARIANT, (Object)0);
        builder.define(COLOR, (Object)0);
        builder.define(IS_TAIL, (Object)false);
        builder.define(PARENT_ID, (Object)-1);
    }

    public Entity getChild() {
        Level level;
        UUID id = this.getChildId();
        if (id != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getEntity(id);
        }
        return null;
    }

    public int getParentIntId() {
        return (Integer)this.entityData.get(PARENT_ID);
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 1) {
            Entity parent = this.getParentSafe();
            if (!this.level().isClientSide) {
                if (parent == null || parent.isRemoved()) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                } else if (parent instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)parent;
                    this.hurtTime = living.hurtTime;
                    this.deathTime = living.deathTime;
                }
            }
        }
        if (this.tickCount % 100 == 0) {
            this.refreshDimensions();
        }
        if (this.tickCount % 30 == 0 && this.getSegmentVariant() == SegmentVariants.MELEE && !this.isTail()) {
            this.dealMeleeDamageAround();
        }
    }

    public float getSpin() {
        float speed = (float)Math.sqrt(this.getDeltaMovement().x * this.getDeltaMovement().x + this.getDeltaMovement().z * this.getDeltaMovement().z);
        this.spin += speed * 2.5E-4f * (float)this.tickCount;
        return this.spin;
    }

    public Vec3 tickMultipartPosition(int headId, Vec3 parentPos, float parentXRot, float parentYRot, float ourYRot, boolean doHeight) {
        double spacing = 1.5f * this.getBbWidth();
        Vec3 buttOffset = this.calcOffsetVec((float)(-spacing), parentXRot, parentYRot);
        Vec3 targetPos = parentPos.add(buttOffset);
        Vec3 currentPos = this.position();
        Vec3 smoothedPos = currentPos.lerp(targetPos, 0.25);
        double yOffset = 0.0;
        if (doHeight) {
            double hgt = this.getLowPartHeight(targetPos.x, targetPos.y, targetPos.z) + this.getHighPartHeight(targetPos.x, targetPos.y, targetPos.z);
            if (Math.abs(hgt - this.prevHeight) > (double)0.2f) {
                this.prevHeight = hgt;
            }
            yOffset = Mth.clamp((double)((double)this.getScale() * this.prevHeight), (double)-0.6f, (double)0.6f);
        }
        double dx = parentPos.x - smoothedPos.x;
        double dz = parentPos.z - smoothedPos.z;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float targetYaw = (float)(Mth.atan2((double)dz, (double)dx) * 57.2957763671875) - 90.0f;
        float smoothedYaw = this.limitAngle(this.getYRot(), targetYaw, 7.5f);
        float targetPitch = (float)(-Mth.atan2((double)yOffset, (double)horizontalDist) * 57.2957763671875);
        float smoothedPitch = this.limitAngle(this.getXRot(), targetPitch, 5.0f);
        double distanceToParent = this.position().distanceTo(parentPos);
        boolean disablePhysics = distanceToParent > 5.0;
        Entity entity = this.getParentSafe();
        if (entity != null) {
            this.setNoGravity(disablePhysics || entity.isNoGravity());
            boolean bl = this.noPhysics = disablePhysics || entity.noPhysics;
            if (disablePhysics) {
                this.teleportTo(entity.getX(), entity.getY(), entity.getZ());
            }
            this.setDeltaMovement(disablePhysics ? entity.getDeltaMovement().multiply(1.0, 0.0, 1.0) : entity.getDeltaMovement());
        }
        this.moveTo(smoothedPos.x, this.onGround() ? this.position().y : smoothedPos.y, smoothedPos.z, smoothedYaw, smoothedPitch);
        this.setYRot(smoothedYaw);
        this.setXRot(smoothedPitch);
        this.yHeadRot = smoothedYaw;
        this.headEntityId = headId;
        return smoothedPos;
    }

    private Vec3 calcOffsetVec(float offsetZ, float xRot, float yRot) {
        return new Vec3(0.0, 0.0, (double)offsetZ).xRot(xRot * ((float)Math.PI / 180)).yRot(-yRot * ((float)Math.PI / 180));
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.FALL);
    }

    public boolean isOpaqueBlockAt(double x, double y, double z) {
        if (this.noPhysics) {
            return false;
        }
        Vec3 pos = new Vec3(x, y, z);
        AABB box = AABB.ofSize((Vec3)pos, (double)1.0, (double)1.0E-6, (double)1.0);
        return this.level().getBlockStates(box).filter(Predicate.not(BlockBehaviour.BlockStateBase::isAir)).anyMatch(state -> state.isSuffocating((BlockGetter)this.level(), BlockPos.containing((Position)pos)) && Shapes.joinIsNotEmpty((VoxelShape)state.getCollisionShape((BlockGetter)this.level(), BlockPos.containing((Position)pos)).move(pos.x, pos.y, pos.z), (VoxelShape)Shapes.create((AABB)box), (BooleanOp)BooleanOp.AND));
    }

    public double getLowPartHeight(double x, double y, double z) {
        double dy;
        if (this.isFluidAt(x, y, z)) {
            return 0.0;
        }
        for (dy = 0.0; dy > -3.0 && !this.isOpaqueBlockAt(x, y + dy, z); dy -= 0.2) {
        }
        return dy;
    }

    public double getHighPartHeight(double x, double y, double z) {
        double dy;
        if (this.isFluidAt(x, y, z)) {
            return 0.0;
        }
        for (dy = 0.0; dy <= 3.0 && this.isOpaqueBlockAt(x, y + dy, z); dy += 0.2) {
        }
        return dy;
    }

    public boolean canBeSeenAsEnemy() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isFluidAt(double x, double y, double z) {
        if (this.noPhysics) {
            return false;
        }
        return !this.level().getFluidState(BlockPos.containing((double)x, (double)y, (double)z)).isEmpty();
    }

    public float limitAngle(float source, float target, float maxChange) {
        float delta = Mth.wrapDegrees((float)(target - source));
        delta = Mth.clamp((float)delta, (float)(-maxChange), (float)maxChange);
        float result = source + delta;
        return Mth.wrapDegrees((float)result);
    }

    public boolean hurt(DamageSource source, float damage) {
        if (!this.isTail() && this.getSegmentVariant() == SegmentVariants.ORGAN) {
            damage *= 2.5f;
        }
        this.hurtMarked = true;
        this.hurtTime = 20;
        return this.hurtHeadId(source, damage);
    }

    public void dealMeleeDamageAround() {
        AABB aabb = this.getBoundingBox().inflate(1.5);
        List entities = this.level().getEntities((Entity)this, aabb, entity -> {
            LivingEntity living;
            return entity instanceof LivingEntity && Utilities.TARGET_SELECTOR.Test(living = (LivingEntity)entity);
        });
        float damage = (float)((Double)SConfig.SERVER.hohl_damage.get() * (Double)SConfig.SERVER.global_damage.get() / 2.0);
        for (Entity entity2 : entities) {
            entity2.hurt(this.level().damageSources().mobAttack((LivingEntity)this), damage);
        }
    }

    public boolean hurtHeadId(DamageSource source, float damage) {
        Entity e;
        if (this.headEntityId != -1 && (e = this.level().getEntity(this.headEntityId)) instanceof Hohlfresser) {
            return e.hurt(source, damage);
        }
        return true;
    }

    public Entity getParentSafe() {
        Level level;
        UUID id = this.getParentId();
        if (id != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity parent = serverLevel.getEntity(id);
            if (parent == null) {
                return null;
            }
            this.entityData.set(PARENT_ID, (Object)parent.getId());
            return parent;
        }
        return null;
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.getUUID());
    }

    public UUID getParentId() {
        return ((Optional)this.entityData.get(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.entityData.set(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public UUID getChildId() {
        return ((Optional)this.entityData.get(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.entityData.set(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public boolean shouldShowName() {
        return false;
    }

    protected void onEffectAdded(MobEffectInstance instance, @Nullable Entity source) {
        super.onEffectAdded(instance, source);
        Entity parent = this.getParentSafe();
        if (!(parent instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingParent = (LivingEntity)parent;
        MobEffectInstance existing = livingParent.getEffect(instance.getEffect());
        if (existing == null || existing.getDuration() < instance.getDuration() - 5) {
            livingParent.addEffect(new MobEffectInstance(instance));
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        InteractionResult interactionResult;
        Entity parent = this.getParentSafe();
        if (parent instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)parent;
            interactionResult = living.interact(player, hand);
        } else {
            interactionResult = super.interact(player, hand);
        }
        return interactionResult;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return List.of();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.getParentId() != null) {
            tag.putUUID("ParentUUID", this.getParentId());
        }
        if (this.getChildId() != null) {
            tag.putUUID("ChildUUID", this.getChildId());
        }
        tag.putFloat("size", ((Float)this.entityData.get(SIZE)).floatValue());
        tag.putInt("variant", ((Integer)this.entityData.get(VARIANT)).intValue());
        tag.putInt("color", ((Integer)this.entityData.get(COLOR)).intValue());
        tag.putBoolean("tail", ((Boolean)this.entityData.get(IS_TAIL)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("ParentUUID")) {
            this.setParentId(tag.getUUID("ParentUUID"));
        }
        if (tag.hasUUID("ChildUUID")) {
            this.setChildId(tag.getUUID("ChildUUID"));
        }
        this.entityData.set(SIZE, (Object)Float.valueOf(tag.getFloat("size")));
        this.entityData.set(VARIANT, (Object)tag.getInt("variant"));
        this.entityData.set(COLOR, (Object)tag.getInt("color"));
        this.entityData.set(IS_TAIL, (Object)tag.getBoolean("tail"));
    }

    public void setSize(float val) {
        this.entityData.set(SIZE, (Object)Float.valueOf(val));
    }

    public void setVariant(int val) {
        this.entityData.set(VARIANT, (Object)val);
    }

    public void setColor(int val) {
        this.entityData.set(COLOR, (Object)val);
    }

    public void setIsTail(boolean val) {
        this.entityData.set(IS_TAIL, (Object)val);
    }

    public float getSize() {
        return ((Float)this.entityData.get(SIZE)).floatValue();
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public boolean isTail() {
        return (Boolean)this.entityData.get(IS_TAIL);
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        return false;
    }

    @Override
    public int chemicalRange() {
        return 0;
    }

    @Override
    public List<? extends String> buffs() {
        return List.of();
    }

    @Override
    public List<? extends String> debuffs() {
        return List.of();
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        EntityDimensions baseDimensions = super.getDefaultDimensions(pose);
        return baseDimensions.scale(this.getSize());
    }

    private void setVariant(SegmentVariants variant) {
        this.entityData.set(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void setVariant() {
        SegmentVariants variant = (SegmentVariants)((Object)Util.getRandom((Object[])SegmentVariants.values(), (RandomSource)this.random));
        this.setVariant(variant);
    }

    public SegmentVariants getSegmentVariant() {
        return SegmentVariants.byId((Integer)this.entityData.get(VARIANT) & 0xFF);
    }

    public static enum SegmentVariants {
        DEFAULT(0),
        MELEE(1),
        ORGAN(2);

        private static final SegmentVariants[] BY_ID;
        private final int id;

        private SegmentVariants(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static SegmentVariants byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        static {
            BY_ID = (SegmentVariants[])Arrays.stream(SegmentVariants.values()).sorted(Comparator.comparingInt(SegmentVariants::getId)).toArray(SegmentVariants[]::new);
        }
    }
}

